--drop procedure dashboard_generateScoreYear;
create PROCEDURE dashboard_generateScoreYear(pid_evaluacion IN  NUMBER,
                                             result_code    OUT NUMBER)
AS


  paa_id INT := 0;


  CURSOR c1 IS

    SELECT e.id     AS id_evaluacion,
           e.meta   AS meta_evaluacion,
           e.CALIFICACION,
           e.CALIFICACION_ANTERIOR,
           a.id     AS id_area,
           a.nombre AS nombre_area,
           a.meta      meta_area,
           a.kpi_id,
           k.NOMBRE AS nombre_kpi,
           c.id     AS id_categoria,
           c.nombre AS nombre_categoria
    FROM EVALUACION e
           JOIN areas a ON e.AREAS_ID = a.ID
           JOIN kpi k ON a.KPI_ID = k.id
           LEFT JOIN categorias c ON a.id = c.AREAS_ID;

  BEGIN

    result_code := 0;


    FOR custom IN c1
    LOOP

      FOR i IN 1..11
      LOOP
        INSERT INTO EVALUACION_DET (ID,
                                    COMENTARIO,
                                    CM_USER_UPDATE,
                                    VISIBLE_PROVEEDOR,
                                    CALIFICACION_ANTERIOR,
                                    CALIFICACION_ACTUAL,
                                    CALIFICACION_GLOBAL,
                                    MES,
                                    CREATED_BY,
                                    UPDATED_BY,
                                    CREATED_DATE,
                                    UPDATED_DATE,
                                    EVALUACION_ID,
                                    CATEGORIAS_ID)
        VALUES (EV_DETAIL_SEQ.nextval,
                'inicial',
                'admin',
                's',
                4.00,
                5.00,
                6.00,
                TO_DATE('2019-' || i || '-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'),
                'admin',
                'admin',
                current_date,
                current_date,
                custom.id_evaluacion,
                custom.id_categoria);
      END LOOP;

    END LOOP;

    result_code := 0;

    -- COMMIT;

    EXCEPTION WHEN OTHERS
    THEN
      result_code := -1;
      ROLLBACK;
      RAISE;


  END;
/

create PROCEDURE dash_global_by_kpi_month(pid_kpi     IN  NUMBER,
                                          pmes        IN  NUMBER,
                                          result_code OUT NUMBER)
AS

  BEGIN

    result_code := 0;


    MERGE INTO evaluacion_det orig
    USING (SELECT k.id AS                                   kpi_id,
                  k.nombre                                  kpi_nombre,
                  e.id                                      eval_id,
                  e.CALIFICACION,
                  e.global,
                  e.AREAS_ID,
                  a.nombre                                  area_nombre,
                  a.meta,
                  c.ID AS                                   categorias_id,
                  c.nombre                                  cat_nombre,
                  c.META_MENSUAL,
                  (ed.CALIFICACION_ACTUAL / c.META_MENSUAL) global_categoria,
                  ed.ID                                     detail_id,
                  to_number(EXTRACT(MONTH FROM ed.mes), 99) mes_number,
                  ed.CALIFICACION_ANTERIOR,
                  ed.CALIFICACION_ACTUAL,
                  ed.CALIFICACION_GLOBAL,
                  ed.mes                                    fecha
           FROM EVALUACION_DET ed
                  JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                  JOIN areas a ON e.AREAS_ID = a.id
                  JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                  JOIN kpi k ON a.KPI_ID = k.id AND k.id = pid_kpi
           WHERE to_number(EXTRACT(MONTH FROM ed.mes), 99) = pmes) detail
    ON (orig.id = detail.detail_id)
    WHEN MATCHED THEN UPDATE SET orig.CALIFICACION_GLOBAL = detail.global_categoria;

    COMMIT;

    EXCEPTION
    WHEN OTHERS
    THEN
      result_code := -1;
      ROLLBACK;
      RAISE;


  END;
/

create PROCEDURE dash_global_by_kpi(pid_kpi     IN  NUMBER,
                                    result_code OUT NUMBER)
AS


  paa_id INT := 0;


  BEGIN

    result_code := 0;


    MERGE INTO evaluacion_det orig
    USING (SELECT k.id AS                                   kpi_id,
                  k.nombre                                  kpi_nombre,
                  e.id                                      eval_id,
                  e.CALIFICACION,
                  e.global,
                  e.AREAS_ID,
                  a.nombre                                  area_nombre,
                  a.meta,
                  c.ID AS                                   categorias_id,
                  c.nombre                                  cat_nombre,
                  c.META_MENSUAL,
                  (ed.CALIFICACION_ACTUAL / c.META_MENSUAL) global_categoria,
                  ed.ID                                     detail_id,
                  to_number(EXTRACT(MONTH FROM ed.mes), 99) mes_number,
                  ed.CALIFICACION_ANTERIOR,
                  ed.CALIFICACION_ACTUAL,
                  ed.CALIFICACION_GLOBAL,
                  ed.mes                                    fecha
           FROM EVALUACION_DET ed
                  JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                  JOIN areas a ON e.AREAS_ID = a.id
                  JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                  JOIN kpi k ON a.KPI_ID = k.id
                                  AND k.id = pid_kpi) detail
    ON (orig.id = detail.detail_id)
    WHEN MATCHED THEN UPDATE SET orig.CALIFICACION_GLOBAL = detail.global_categoria;

    COMMIT;

    EXCEPTION WHEN OTHERS
    THEN
      result_code := -1;
      ROLLBACK;
      RAISE;


  END;
/

create PROCEDURE d_eval_global_month(pid_kpi     IN  NUMBER, pmes IN NUMBER,
                               result_code OUT NUMBER)
AS


  paa_id INT := 0;


  BEGIN

    result_code := 0;

    MERGE INTO evaluacion orig
    USING (SELECT k.id id_kpi, e.id id_eval, a.id, avg(ed.CALIFICACION_GLOBAL) AS average
           FROM EVALUACION_DET ed
                  JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                  JOIN areas a ON e.AREAS_ID = a.id
                  JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                  JOIN kpi k ON a.KPI_ID = k.id
                                  AND k.id = pid_kpi
           WHERE to_number(EXTRACT(MONTH FROM ed.mes), 99) = pmes
           GROUP BY k.id, e.id, a.id, to_number(EXTRACT(MONTH FROM ed.mes), 99)) detail
    ON (orig.id = detail.id_eval)
    WHEN MATCHED THEN UPDATE SET orig.GLOBAL = detail.average;

    COMMIT;

    EXCEPTION WHEN OTHERS
    THEN
      result_code := -1;
      ROLLBACK;
      RAISE;

  END;
/

create PROCEDURE get_detail_month(pkpi_id IN NUMBER, pmes IN NUMBER, p_cursor IN OUT SYS_REFCURSOR)
AS
  BEGIN
    OPEN p_cursor FOR
    SELECT k.id AS                                   kpi_id,
           k.nombre                                  kpi_nombre,
           e.id                                      eval_id,
           e.global                                  global_actual,
           e.AREAS_ID,
           a.nombre                                  area_nombre,
           c.ID AS                                   categorias_id,
           c.nombre                                  cat_nombre,
           c.META_MENSUAL,
           (ed.CALIFICACION_ACTUAL / c.META_MENSUAL) global_categoria,
           ed.ID                                     detail_id,
           to_number(EXTRACT(MONTH FROM ed.mes), 99) mes_number,
           ed.CALIFICACION_ACTUAL,
           ed.CALIFICACION_GLOBAL
    FROM EVALUACION_DET ed
           JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
           JOIN areas a ON e.AREAS_ID = a.id
           JOIN categorias c ON ed.CATEGORIAS_ID = c.id
           JOIN kpi k ON a.KPI_ID = k.id AND k.id = pkpi_id
    WHERE to_number(EXTRACT(MONTH FROM ed.mes), 99) = pmes
    ORDER BY k.id, e.id, a.id, c.id, to_number(EXTRACT(MONTH FROM ed.mes), 99);

  END;
/

create PROCEDURE get_detail_global(pkpi_id IN NUMBER, p_cursor IN OUT SYS_REFCURSOR)
AS
  BEGIN
    OPEN p_cursor FOR
    SELECT k.id AS                                   kpi_id,
           k.nombre                                  kpi_nombre,
           e.id                                      eval_id,
           e.global                                  global_actual,
           e.AREAS_ID,
           a.nombre                                  area_nombre,
           c.ID AS                                   categorias_id,
           c.nombre                                  cat_nombre,
           c.META_MENSUAL,
           (ed.CALIFICACION_ACTUAL / c.META_MENSUAL) global_categoria,
           ed.ID                                     detail_id,
           to_number(EXTRACT(MONTH FROM ed.mes), 99) mes_number,
           ed.CALIFICACION_ACTUAL,
           ed.CALIFICACION_GLOBAL
    FROM EVALUACION_DET ed
           JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
           JOIN areas a ON e.AREAS_ID = a.id
           JOIN categorias c ON ed.CATEGORIAS_ID = c.id
           JOIN kpi k ON a.KPI_ID = k.id AND k.id = pkpi_id
    ORDER BY k.id, e.id, a.id, c.id, to_number(EXTRACT(MONTH FROM ed.mes), 99);

  END;
/


CREATE OR REPLACE PROCEDURE P_GET_PEN_QUIZ_USERS( p_cursor IN OUT SYS_REFCURSOR)
as
BEGIN

    OPEN p_cursor FOR
        select u.USER_NAME,u.USER_TYPE,p.nombre,p.id
        from proveedores p
                 join USERS_PROVEEDORES up
                      on up.PROVEEDORES_ID = p.id
                 join users u
                      on u.id = up.USERS_ID
        where UPPER(u.USER_TYPE) in
              ('CLIENTE INTERNO')
          and not exists(
                select 'x' from EVALUACION_PROVEEDOR ep
                where ep.CREATED_BY = u.USER_NAME
                  and ep.year = to_char(add_months(sysdate, -1), 'YYYY')
                  and ep.month = to_char(add_months(sysdate, -1), 'MM')
            )
    ;

end;