/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.Tag;

public class Tags {
    private Tags() {
        throw new UnsupportedOperationException();
    }

    public static Set<Tag> toTags(Multimap<String, ApiListing> apiListings) {
        Iterable allListings = Iterables.concat(BuilderDefaults.nullToEmptyMultimap(apiListings).asMap().values());
        ImmutableList tags = FluentIterable.from((Iterable)allListings).transformAndConcat(Tags.collectTags()).toList();
        TreeSet tagSet = Sets.newTreeSet(Tags.byTagName());
        tagSet.addAll(tags);
        return tagSet;
    }

    public static Comparator<Tag> byTagName() {
        return new Comparator<Tag>(){

            @Override
            public int compare(Tag first, Tag second) {
                return first.getName().compareTo(second.getName());
            }
        };
    }

    static Function<String, Tag> toTag(final ApiListing listing) {
        return new Function<String, Tag>(){

            public Tag apply(String input) {
                return new Tag(input, listing.getDescription());
            }
        };
    }

    static Function<ApiListing, Iterable<Tag>> collectTags() {
        return new Function<ApiListing, Iterable<Tag>>(){

            public Iterable<Tag> apply(ApiListing input) {
                return FluentIterable.from(input.getTags()).filter(Tags.emptyTags()).transform(Tags.toTag(input)).toSet();
            }
        };
    }

    public static Predicate<String> emptyTags() {
        return new Predicate<String>(){

            public boolean apply(String input) {
                return !Strings.isNullOrEmpty((String)input);
            }
        };
    }
}

