/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.util.Assert;

public class PersistentEntityParameterValueProvider<P extends PersistentProperty<P>>
implements ParameterValueProvider<P> {
    private final PersistentEntity<?, P> entity;
    private final PropertyValueProvider<P> provider;
    private final Object parent;

    public PersistentEntityParameterValueProvider(PersistentEntity<?, P> entity, PropertyValueProvider<P> provider, Object parent) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        Assert.notNull(provider, (String)"Provider must not be null!");
        this.entity = entity;
        this.provider = provider;
        this.parent = parent;
    }

    @Override
    public <T> T getParameterValue(PreferredConstructor.Parameter<T, P> parameter) {
        PreferredConstructor<T, P> constructor = this.entity.getPersistenceConstructor();
        if (constructor.isEnclosingClassParameter(parameter)) {
            return (T)this.parent;
        }
        P property = this.entity.getPersistentProperty(parameter.getName());
        if (property == null) {
            throw new MappingException(String.format("No property %s found on entity %s to bind constructor parameter to!", parameter.getName(), this.entity.getType()));
        }
        return this.provider.getPropertyValue(property);
    }
}

