-- Generated by Oracle SQL Developer Data Modeler 19.2.0.182.1216
--   at:        2019-11-07 15:34:52 CST
--   site:      Oracle Database 11g
--   type:      Oracle Database 11g



CREATE TABLE archivos (
    id             INTEGER NOT NULL,
    nombre         NVARCHAR2(100),
    ruta           NVARCHAR2(200),
    tipo_archivo   NVARCHAR2(50),
    entidad        NVARCHAR2(50),
    entidad_id     INTEGER
);

ALTER TABLE archivos ADD CONSTRAINT archivos_pk PRIMARY KEY ( id );

CREATE TABLE areas (
    id             INTEGER NOT NULL,
    nombre         NVARCHAR2(100),
    meta           INTEGER,
    created_date   DATE,
    created_by     NVARCHAR2(50),
    updated_by     NVARCHAR2(50),
    updated_date   DATE,
    kpi_id         INTEGER NOT NULL
);

ALTER TABLE areas ADD CONSTRAINT areas_pk PRIMARY KEY ( id );

CREATE TABLE categorias (
    id             INTEGER NOT NULL,
    nombre         NVARCHAR2(50),
    meta_mensual   INTEGER,
    meta_anual     INTEGER,
    created_date   DATE,
    updated_date   DATE,
    created_by     NVARCHAR2(50),
    updated_by     NVARCHAR2(50),
    areas_id       INTEGER NOT NULL
);

ALTER TABLE categorias ADD CONSTRAINT categorias_pk PRIMARY KEY ( id );

CREATE TABLE evaluacion (
    id                      INTEGER NOT NULL,
    meta                    INTEGER NOT NULL,
    calificacion            NUMBER(10, 2),
    estado                  NVARCHAR2(50),
    year                    NVARCHAR2(50),
    calificacion_anterior   NUMBER(10, 2),
    tendencia               NVARCHAR2(50),
    global                  NUMBER(10, 2),
    created_date            DATE,
    updated_date            DATE,
    created_by              NVARCHAR2(50),
    updated_by              NVARCHAR2(50),
    proveedores_id          INTEGER NOT NULL,
    areas_id                INTEGER NOT NULL
);

ALTER TABLE evaluacion ADD CONSTRAINT evaluacion_pk PRIMARY KEY ( id );

CREATE TABLE evaluacion_det (
    id                      INTEGER NOT NULL,
    comentario              NVARCHAR2(50),
    cm_user_update          NVARCHAR2(50),
    visible_proveedor       CHAR(1 CHAR),
    calificacion_anterior   NUMBER(12, 2),
    calificacion_actual     NUMBER(12, 2),
    calificacion_global     NUMBER(12, 2),
    mes                     DATE,
    created_by              DATE,
    updated_by              DATE,
    created_date            DATE,
    updated_date            DATE,
    evaluacion_id           INTEGER NOT NULL,
    categorias_id           INTEGER NOT NULL
);

ALTER TABLE evaluacion_det ADD CONSTRAINT evaluacion_det_pk PRIMARY KEY ( id );

CREATE TABLE evaluacion_det_commentarios (
    id                    INTEGER NOT NULL,
    comentario            NVARCHAR2(300),
    created_by            NVARCHAR2(50),
    created_date          DATE,
    updated_by            NVARCHAR2(50),
    cm_usuario_modifico   NVARCHAR2(50),
    updated_date          DATE,
    evaluacion_det_id     INTEGER NOT NULL
);

ALTER TABLE evaluacion_det_commentarios ADD CONSTRAINT evaluacion_det_commentarios_pk PRIMARY KEY ( id );

CREATE TABLE kpi (
    id             INTEGER NOT NULL,
    nombre         NVARCHAR2(100) NOT NULL,
    created_date   DATE,
    updated_date   TIMESTAMP
);

ALTER TABLE kpi ADD CONSTRAINT kpi_pk PRIMARY KEY ( id );

CREATE TABLE notificaciones_template (
    id            INTEGER NOT NULL,
    nombre        NVARCHAR2(100),
    descripcion   NVARCHAR2(100),
    subject       NVARCHAR2(200),
    body          BLOB,
    tipo          NVARCHAR2(100)
);

ALTER TABLE notificaciones_template ADD CONSTRAINT notificaciones_pk PRIMARY KEY ( id );

CREATE TABLE plan_accion (
    id                  INTEGER NOT NULL,
    objetivo            NVARCHAR2(200),
    estado              NVARCHAR2(50),
    mes                 DATE,
    created_by          NVARCHAR2(50),
    created_date        DATE,
    updated_by          NVARCHAR2(50),
    updated_date        DATE,
    fecha_compromiso    DATE,
    avance_proveedor    NUMBER(12, 2),
    avance_cm           NUMBER(12, 2),
    evaluacion_det_id   INTEGER NOT NULL
);

ALTER TABLE plan_accion ADD CONSTRAINT plan_accion_pk PRIMARY KEY ( id );

CREATE TABLE plan_accion_commentarios (
    id                    INTEGER NOT NULL,
    comentario            NVARCHAR2(300),
    created_by            NVARCHAR2(50),
    created_date          DATE,
    updated_by            NVARCHAR2(50),
    cm_usuario_modifico   NVARCHAR2(50),
    updated_date          DATE,
    plan_accion_det_id    INTEGER NOT NULL
);

ALTER TABLE plan_accion_commentarios ADD CONSTRAINT plan_accion_commentarios_pk PRIMARY KEY ( id );

CREATE TABLE plan_accion_det (
    id               INTEGER NOT NULL,
    comentario       NVARCHAR2(300),
    created_date     DATE,
    created_by       NVARCHAR2(50),
    updated_by       NVARCHAR2(50),
    estado           NVARCHAR2(50),
    plan_accion_id   INTEGER NOT NULL,
    categorias_id    INTEGER NOT NULL
);

ALTER TABLE plan_accion_det ADD CONSTRAINT plan_accion_det_pk PRIMARY KEY ( id );

CREATE TABLE proveedores (
    id                    INTEGER NOT NULL,
    contacto              NVARCHAR2(50),
    email                 NVARCHAR2(50),
    estado                NVARCHAR2(50),
    evaluacion_actual     NUMBER(12, 2),
    evaluacion_global     NUMBER(12, 2),
    fecha_creacion        DATE,
    fecha_actualizacion   DATE,
    creado_por            NVARCHAR2(50),
    tendencia             NVARCHAR2(50)
);

ALTER TABLE proveedores ADD CONSTRAINT test_pk PRIMARY KEY ( id );

CREATE TABLE roles_permisos (
    id             INTEGER NOT NULL,
    role_name      NVARCHAR2(50),
    descripcion    NVARCHAR2(100),
    created_date   DATE
);

ALTER TABLE roles_permisos ADD CONSTRAINT roles_permisos_pk PRIMARY KEY ( id );

CREATE TABLE users (
    id          INTEGER NOT NULL,
    user_name   NVARCHAR2(50),
    password    NVARCHAR2(200),
    user_type   NVARCHAR2(100),
    email       NVARCHAR2(100),
    status      CHAR(1),
    enabled     CHAR 
--  WARNING: CHAR size not specified 
);

ALTER TABLE users ADD CONSTRAINT users_pk PRIMARY KEY ( id );

CREATE TABLE users_proveedores (
    id               INTEGER NOT NULL,
    created_date     DATE,
    updated_date     DATE,
    proveedores_id   INTEGER NOT NULL,
    users_id         INTEGER NOT NULL
);

ALTER TABLE users_proveedores ADD CONSTRAINT users_proveedores_pk PRIMARY KEY ( id );

CREATE TABLE users_roles (
    id                  INTEGER NOT NULL,
    roles_permisos_id   INTEGER NOT NULL,
    users_id            INTEGER NOT NULL
);

ALTER TABLE users_roles ADD CONSTRAINT users_roles_pk PRIMARY KEY ( id );

ALTER TABLE areas
    ADD CONSTRAINT areas_kpi_fk FOREIGN KEY ( kpi_id )
        REFERENCES kpi ( id );

ALTER TABLE categorias
    ADD CONSTRAINT categorias_areas_fk FOREIGN KEY ( areas_id )
        REFERENCES areas ( id );

ALTER TABLE evaluacion_det_commentarios
    ADD CONSTRAINT eval_det_comm_fk FOREIGN KEY ( evaluacion_det_id )
        REFERENCES evaluacion_det ( id );

ALTER TABLE evaluacion
    ADD CONSTRAINT evaluacion_areas_fk FOREIGN KEY ( areas_id )
        REFERENCES areas ( id );

ALTER TABLE evaluacion_det
    ADD CONSTRAINT evaluacion_det_categorias_fk FOREIGN KEY ( categorias_id )
        REFERENCES categorias ( id );

ALTER TABLE evaluacion_det
    ADD CONSTRAINT evaluacion_det_evaluacion_fk FOREIGN KEY ( evaluacion_id )
        REFERENCES evaluacion ( id );

ALTER TABLE evaluacion
    ADD CONSTRAINT evaluacion_proveedores_fk FOREIGN KEY ( proveedores_id )
        REFERENCES proveedores ( id );

ALTER TABLE plan_accion_det
    ADD CONSTRAINT plan_accion_det_cat_fk FOREIGN KEY ( categorias_id )
        REFERENCES categorias ( id );

ALTER TABLE plan_accion_commentarios
    ADD CONSTRAINT plan_accion_det_com_fk FOREIGN KEY ( plan_accion_det_id )
        REFERENCES plan_accion_det ( id );

ALTER TABLE plan_accion_det
    ADD CONSTRAINT plan_accion_det_plan_accion_fk FOREIGN KEY ( plan_accion_id )
        REFERENCES plan_accion ( id );

ALTER TABLE plan_accion
    ADD CONSTRAINT plan_accion_evaluacion_det_fk FOREIGN KEY ( evaluacion_det_id )
        REFERENCES evaluacion_det ( id );

ALTER TABLE users_proveedores
    ADD CONSTRAINT users_proveedores_users_fk FOREIGN KEY ( users_id )
        REFERENCES users ( id );

ALTER TABLE users_proveedores
    ADD CONSTRAINT users_proves_prove_fk FOREIGN KEY ( proveedores_id )
        REFERENCES proveedores ( id );

ALTER TABLE users_roles
    ADD CONSTRAINT users_roles_roles_permisos_fk FOREIGN KEY ( roles_permisos_id )
        REFERENCES roles_permisos ( id );

ALTER TABLE users_roles
    ADD CONSTRAINT users_roles_users_fk FOREIGN KEY ( users_id )
        REFERENCES users ( id );



-- Oracle SQL Developer Data Modeler Summary Report: 
-- 
-- CREATE TABLE                            16
-- CREATE INDEX                             0
-- ALTER TABLE                             31
-- CREATE VIEW                              0
-- ALTER VIEW                               0
-- CREATE PACKAGE                           0
-- CREATE PACKAGE BODY                      0
-- CREATE PROCEDURE                         0
-- CREATE FUNCTION                          0
-- CREATE TRIGGER                           0
-- ALTER TRIGGER                            0
-- CREATE COLLECTION TYPE                   0
-- CREATE STRUCTURED TYPE                   0
-- CREATE STRUCTURED TYPE BODY              0
-- CREATE CLUSTER                           0
-- CREATE CONTEXT                           0
-- CREATE DATABASE                          0
-- CREATE DIMENSION                         0
-- CREATE DIRECTORY                         0
-- CREATE DISK GROUP                        0
-- CREATE ROLE                              0
-- CREATE ROLLBACK SEGMENT                  0
-- CREATE SEQUENCE                          0
-- CREATE MATERIALIZED VIEW                 0
-- CREATE MATERIALIZED VIEW LOG             0
-- CREATE SYNONYM                           0
-- CREATE TABLESPACE                        0
-- CREATE USER                              0
-- 
-- DROP TABLESPACE                          0
-- DROP DATABASE                            0
-- 
-- REDACTION POLICY                         0
-- 
-- ORDS DROP SCHEMA                         0
-- ORDS ENABLE SCHEMA                       0
-- ORDS ENABLE OBJECT                       0
-- 
-- ERRORS                                   0
-- WARNINGS                                 1
