CREATE OR REPLACE PROCEDURE dashboard_generateScoreYear(pid_evaluacion IN  NUMBER,
                                                        result_code    OUT NUMBER)
AS


  paa_id INT := 0;


  CURSOR c1 IS

    SELECT e.id     AS id_evaluacion,
           e.meta   AS meta_evaluacion,
           e.CALIFICACION,
           e.CALIFICACION_ANTERIOR,
           a.id     AS id_area,
           a.nombre AS nombre_area,
           a.meta      meta_area,
           a.kpi_id,
           k.NOMBRE AS nombre_kpi,
           c.id     AS id_categoria,
           c.nombre AS nombre_categoria
    FROM EVALUACION e
           JOIN areas a ON e.AREAS_ID = a.ID
           JOIN kpi k ON a.KPI_ID = k.id
           LEFT JOIN categorias c ON a.id = c.AREAS_ID;

  BEGIN

    result_code := 0;


    FOR custom IN c1
    LOOP

      FOR i IN 1..11
      LOOP
        INSERT INTO EVALUACION_DET (ID,
                                    COMENTARIO,
                                    CM_USER_UPDATE,
                                    VISIBLE_PROVEEDOR,
                                    CALIFICACION_ANTERIOR,
                                    CALIFICACION_ACTUAL,
                                    CALIFICACION_GLOBAL,
                                    MES,
                                    CREATED_BY,
                                    UPDATED_BY,
                                    CREATED_DATE,
                                    UPDATED_DATE,
                                    EVALUACION_ID,
                                    CATEGORIAS_ID)
        VALUES (EV_DETAIL_SEQ.nextval,
                'inicial',
                'admin',
                's',
                4.00,
                5.00,
                6.00,
                TO_DATE('2019-' || i || '-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'),
                'admin',
                'admin',
                current_date,
                current_date,
                custom.id_evaluacion,
                custom.id_categoria);
      END LOOP;

    END LOOP;

    result_code := 0;

    -- COMMIT;

    EXCEPTION WHEN OTHERS
    THEN
      result_code := -1;
      ROLLBACK;
      RAISE;


  END;
/

CREATE OR REPLACE PROCEDURE dash_global_by_kpi_month(pid_kpi     IN  NUMBER,
                                                     pmes        IN  NUMBER,
                                                     result_code OUT NUMBER)
AS

  BEGIN

    result_code := 0;


    MERGE INTO evaluacion_det orig
    USING (SELECT k.id AS                                   kpi_id,
                  k.nombre                                  kpi_nombre,
                  e.id                                      eval_id,
                  e.CALIFICACION,
                  e.global,
                  e.AREAS_ID,
                  a.nombre                                  area_nombre,
                  a.meta,
                  c.ID AS                                   categorias_id,
                  c.nombre                                  cat_nombre,
                  c.META_MENSUAL,
                  (ed.CALIFICACION_ACTUAL / c.META_MENSUAL) global_categoria,
                  ed.ID                                     detail_id,
                  to_number(EXTRACT(MONTH FROM ed.mes), 99) mes_number,
                  ed.CALIFICACION_ANTERIOR,
                  ed.CALIFICACION_ACTUAL,
                  ed.CALIFICACION_GLOBAL,
                  ed.mes                                    fecha
           FROM EVALUACION_DET ed
                  JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                  JOIN areas a ON e.AREAS_ID = a.id
                  JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                  JOIN kpi k ON a.KPI_ID = k.id AND k.id = pid_kpi
           WHERE to_number(EXTRACT(MONTH FROM ed.mes), 99) = pmes) detail
    ON (orig.id = detail.detail_id)
    WHEN MATCHED THEN UPDATE SET orig.CALIFICACION_GLOBAL = detail.global_categoria;

    COMMIT;

    EXCEPTION
    WHEN OTHERS
    THEN
      result_code := -1;
      ROLLBACK;
      RAISE;


  END;
/

CREATE OR REPLACE PROCEDURE dash_global_by_kpi(pid_kpi     IN  NUMBER,
                                               result_code OUT NUMBER)
AS


  paa_id INT := 0;


  BEGIN

    result_code := 0;


    MERGE INTO evaluacion_det orig
    USING (SELECT k.id AS                                   kpi_id,
                  k.nombre                                  kpi_nombre,
                  e.id                                      eval_id,
                  e.CALIFICACION,
                  e.global,
                  e.AREAS_ID,
                  a.nombre                                  area_nombre,
                  a.meta,
                  c.ID AS                                   categorias_id,
                  c.nombre                                  cat_nombre,
                  c.META_MENSUAL,
                  (ed.CALIFICACION_ACTUAL / c.META_MENSUAL) global_categoria,
                  ed.ID                                     detail_id,
                  to_number(EXTRACT(MONTH FROM ed.mes), 99) mes_number,
                  ed.CALIFICACION_ANTERIOR,
                  ed.CALIFICACION_ACTUAL,
                  ed.CALIFICACION_GLOBAL,
                  ed.mes                                    fecha
           FROM EVALUACION_DET ed
                  JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                  JOIN areas a ON e.AREAS_ID = a.id
                  JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                  JOIN kpi k ON a.KPI_ID = k.id
                                  AND k.id = pid_kpi) detail
    ON (orig.id = detail.detail_id)
    WHEN MATCHED THEN UPDATE SET orig.CALIFICACION_GLOBAL = detail.global_categoria;

    COMMIT;

    EXCEPTION WHEN OTHERS
    THEN
      result_code := -1;
      ROLLBACK;
      RAISE;


  END;
/

CREATE OR REPLACE PROCEDURE d_eval_global_month(pid_kpi     IN  NUMBER, pmes IN NUMBER,
                                                result_code OUT NUMBER)
AS


  paa_id INT := 0;


  BEGIN

    result_code := 0;

    MERGE INTO evaluacion orig
    USING (SELECT k.id id_kpi, e.id id_eval, a.id, avg(ed.CALIFICACION_GLOBAL) AS average
           FROM EVALUACION_DET ed
                  JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                  JOIN areas a ON e.AREAS_ID = a.id
                  JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                  JOIN kpi k ON a.KPI_ID = k.id
                                  AND k.id = pid_kpi
           WHERE to_number(EXTRACT(MONTH FROM ed.mes), 99) = pmes
           GROUP BY k.id, e.id, a.id, to_number(EXTRACT(MONTH FROM ed.mes), 99)) detail
    ON (orig.id = detail.id_eval)
    WHEN MATCHED THEN UPDATE SET orig.GLOBAL = detail.average;

    COMMIT;

    EXCEPTION WHEN OTHERS
    THEN
      result_code := -1;
      ROLLBACK;
      RAISE;

  END;
/

CREATE OR REPLACE PROCEDURE get_detail_month(pkpi_id IN NUMBER, pmes IN NUMBER, p_cursor IN OUT SYS_REFCURSOR)
AS
  BEGIN
    OPEN p_cursor FOR
    SELECT k.id AS                                   kpi_id,
           k.nombre                                  kpi_nombre,
           e.id                                      eval_id,
           e.global                                  global_actual,
           e.AREAS_ID,
           a.nombre                                  area_nombre,
           c.ID AS                                   categorias_id,
           c.nombre                                  cat_nombre,
           c.META_MENSUAL,
           (ed.CALIFICACION_ACTUAL / c.META_MENSUAL) global_categoria,
           ed.ID                                     detail_id,
           to_number(EXTRACT(MONTH FROM ed.mes), 99) mes_number,
           ed.CALIFICACION_ACTUAL,
           ed.CALIFICACION_GLOBAL
    FROM EVALUACION_DET ed
           JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
           JOIN areas a ON e.AREAS_ID = a.id
           JOIN categorias c ON ed.CATEGORIAS_ID = c.id
           JOIN kpi k ON a.KPI_ID = k.id AND k.id = pkpi_id
    WHERE to_number(EXTRACT(MONTH FROM ed.mes), 99) = pmes
    ORDER BY k.id, e.id, a.id, c.id, to_number(EXTRACT(MONTH FROM ed.mes), 99);

  END;
/

CREATE OR REPLACE PROCEDURE get_detail_global(pkpi_id IN NUMBER, p_cursor IN OUT SYS_REFCURSOR)
AS
  BEGIN
    OPEN p_cursor FOR
    SELECT k.id AS                                   kpi_id,
           k.nombre                                  kpi_nombre,
           e.id                                      eval_id,
           e.global                                  global_actual,
           e.AREAS_ID,
           a.nombre                                  area_nombre,
           c.ID AS                                   categoria_id,
           c.nombre                                  cat_nombre,
           c.META_MENSUAL,
           (ed.CALIFICACION_ACTUAL / c.META_MENSUAL) global_categoria,
           ed.ID                                     detail_id,
           to_number(EXTRACT(MONTH FROM ed.mes), 99) mes_number,
           ed.CALIFICACION_ACTUAL,
           ed.CALIFICACION_GLOBAL
    FROM EVALUACION_DET ed
           JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
           JOIN areas a ON e.AREAS_ID = a.id
           JOIN categorias c ON ed.CATEGORIAS_ID = c.id
           JOIN kpi k ON a.KPI_ID = k.id AND k.id = pkpi_id
    ORDER BY k.id, e.id, a.id, c.id, to_number(EXTRACT(MONTH FROM ed.mes), 99);

  END;
/

CREATE OR REPLACE PROCEDURE get_detail_global_month(pkpi_id IN NUMBER, p_cursor IN OUT SYS_REFCURSOR)
AS
  BEGIN
    OPEN p_cursor FOR
    SELECT kpi_id, mes, avg(promedio_area) AS promedio
    FROM (SELECT k.id AS                                   kpi_id,
                 e.id                                      eval_id,
                 a.id                                      areas_id,
                 to_number(EXTRACT(MONTH FROM ed.mes), 99) mes,
                 avg(ed.CALIFICACION_GLOBAL)               promedio_area
          FROM EVALUACION_DET ed
                 JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                 JOIN areas a ON e.AREAS_ID = a.id
                 JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                 JOIN kpi k ON a.KPI_ID = k.id AND k.id = pkpi_id
          GROUP BY k.id, e.id, a.id, to_number(EXTRACT(MONTH FROM ed.mes), 99))
    GROUP BY kpi_id, mes
    ORDER BY kpi_id, mes;

  END;
/














drop procedure  scorecard.pc_create_up_scorecard;
create or replace PROCEDURE pc_create_up_scorecard(p_provider_id IN PROVEEDORES.ID%TYPE,
                                                   p_month       IN SCORECARD_PROVIDER_MONTH.MONTH%TYPE,
                                                   p_year        IN SCORECARD_PROVIDER.YEAR%TYPE)
    IS
    -- area
    --type acursor is ref cursor;
    --cur_score_area  acursor;

    CURSOR cur_score_cate (p_provider_id IN scorecard_PROVIDER.PROVEEDORES_ID%TYPE,
        p_month IN SCORECARD_PROVIDER_MONTH.MONTH%TYPE,
        p_year IN scorecard_PROVIDER.YEAR%TYPE) is
        SELECT to_number(EXTRACT(MONTH FROM ed.mes), 99)  mes,
               to_number(EXTRACT(YEAR FROM ed.mes), 9999) YEAR,
               p.NOMBRE,a.NOMBRE,c.NOMBRE,
               p.id,
               a.ID,c.id,
               avg(ed.CALIFICACION_ACTUAL) promedio_area
               -- INTO           L_MONTH, L_YEAR, L_NAME, L_PROVEEDORES_ID, L_LAST_SCORE
        FROM EVALUACION_DET ed
                 JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                 JOIN areas a ON e.AREAS_ID = a.id
                 JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                 JOIN kpi k ON a.KPI_ID = k.id
                 JOIN PROVEEDORES P on e.PROVEEDORES_ID = P.ID
        WHERE p.id = p_provider_id
          AND to_number(EXTRACT(MONTH FROM ed.mes), 99) = p_month
          AND to_number(EXTRACT(year FROM ed.mes), 9999) = p_year
        GROUP BY k.id, e.id, a.id,c.id, p.nombre,a.nombre,c.nombre, p.id
                , to_number(EXTRACT(MONTH FROM ed.mes), 99),
                 to_number(EXTRACT(YEAR FROM ed.mes), 9999)
        order by mes;

--   -- por area nota total de todas las areas agrupadas por categoria
    CURSOR cur_score_area (
        p_provider_id scorecard_PROVIDER.PROVEEDORES_ID%TYPE,
        p_month SCORECARD_PROVIDER_MONTH.MONTH%TYPE,
        p_year scorecard_PROVIDER.YEAR%TYPE,
        p_area_id IN scorecard_PROVIDER.YEAR%TYPE) is
        SELECT  avg(ed.CALIFICACION_ACTUAL)
        FROM EVALUACION_DET ed
                 JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                 JOIN areas a ON e.AREAS_ID = a.id
                 JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                 JOIN PROVEEDORES P on e.PROVEEDORES_ID = P.ID
        WHERE p.id = p_provider_id
          AND to_number(EXTRACT(MONTH FROM ed.mes), 99) = p_month
          AND to_number(EXTRACT(year FROM ed.mes), 9999) = p_year
          and a.id = p_area_id
    --group by ed.id
--   GROUP BY c.id, p.nombre,c.nombre, p.id, to_number(EXTRACT(MONTH FROM ed.mes), 99),
--            to_number(EXTRACT(YEAR FROM ed.mes), 9999)
    ;

--   p.NOMBRE,a.NOMBRE,c.nombre catname,
--          p.id,

    --global
    CURSOR cur_score_global (p_provider_id scorecard_PROVIDER.PROVEEDORES_ID%TYPE,
        p_month SCORECARD_PROVIDER_MONTH.MONTH%TYPE,
        p_year scorecard_PROVIDER.YEAR%TYPE) is
        select -- mes, YEAR, NOMBRE, provedorId,
               -- categoria_id,
               avg(promedio_categoria),NOMBRE
               -- INTO L_TOTAL_AVG
        from (SELECT e.id                                       eval_id,
                     c.id                                       categoria_id,
                     to_number(EXTRACT(MONTH FROM ed.mes), 99)  mes,
                     to_number(EXTRACT(YEAR FROM ed.mes), 9999) YEAR,
                     p.NOMBRE,
                     p.id                                       provedorId,
                     avg(ed.CALIFICACION_ACTUAL)                promedio_categoria
              FROM EVALUACION_DET ed
                       JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                       JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                       JOIN PROVEEDORES P on e.PROVEEDORES_ID = P.ID
              where p.id = p_provider_id
                and to_number(EXTRACT(MONTH FROM ed.mes), 99) = p_month
                AND to_number(EXTRACT(year FROM ed.mes), 9999) = p_year
              GROUP BY e.id, c.id, p.nombre, p.id, to_number(EXTRACT(MONTH FROM ed.mes), 99),
                       to_number(EXTRACT(YEAR FROM ed.mes), 9999))
        group by  YEAR, NOMBRE, provedorId; --mes,

    CURSOR cur_score_year (
        p_provider_id scorecard_PROVIDER.PROVEEDORES_ID%TYPE,
        p_month IN SCORECARD_PROVIDER_MONTH.MONTH%TYPE,
        p_year scorecard_PROVIDER.YEAR%TYPE) is
        select p.id, p.LAST_SCORE
        from SCORECARD.SCORECARD_PROVIDER p
        where p.PROVEEDORES_ID = p_provider_id
          and p.YEAR = p_year
          and p.MONTH = p_month;

    L_NAME               scorecard_PROVIDER.NAME%TYPE;
    L_LAST_SCORE_AREA     SCORECARD_PROVIDER_MONTH.SCORE%TYPE;
    L_LAST_SCORE         scorecard_PROVIDER.LAST_SCORE%TYPE; -- CATGORIAS
    L_BEFORE_SCORE       scorecard_PROVIDER.BEFORE_SCORE%TYPE;
    L_TOTAL_AVG          scorecard_PROVIDER.TOTAL_AVG%TYPE;
    L_TARGET             scorecard_PROVIDER.TARGET%TYPE:=5;
    L_YEAR               scorecard_PROVIDER.YEAR%TYPE:=p_year;
    L_CREATED_DATE       scorecard_PROVIDER.CREATED_DATE%TYPE;
    L_PROVEEDORES_ID     scorecard_PROVIDER.PROVEEDORES_ID%TYPE:=p_provider_id;
    L_SCORECARD_PROVIDER SCORECARD_PROVIDER.PROVEEDORES_ID%TYPE;
    L_MONTH                 SCORECARD_PROVIDER_MONTH.MONTH%TYPE:=p_month;
    L_SCORECARD_PROVIDER_ID SCORECARD_PROVIDER.ID%TYPE;
    L_NOMBRE_AREA        scorecard_PROVIDER_MONTH.NOMBRE_AREA%TYPE;
    L_NOMBRE_CATEGORIA   scorecard_PROVIDER_MONTH.NOMBRE_CATEGORIA%TYPE;
    L_ID_AREA        AREAS.ID%TYPE;
    L_ID_CATEGORIA   CATEGORIAS.ID%TYPE;

BEGIN
    --DBMS_OUTPUT.ENABLE (buffer_size IN INTEGER DEFAULT 20000);

    OPEN cur_score_global(p_provider_id,p_month,p_year);
    FETCH cur_score_global INTO L_TOTAL_AVG,L_NAME;
    CLOSE cur_score_global;

    OPEN cur_score_year (p_provider_id,p_month,p_year);
    FETCH cur_score_year INTO L_SCORECARD_PROVIDER_ID, L_LAST_SCORE;

    CLOSE cur_score_year;


    if L_SCORECARD_PROVIDER_ID > 0
    then
        UPDATE SCORECARD.SCORECARD_PROVIDER
        SET NAME         = L_NAME,
            LAST_SCORE   = L_TOTAL_AVG, --L_LAST_SCORE,
            BEFORE_SCORE = L_BEFORE_SCORE,
            TOTAL_AVG    = L_TOTAL_AVG,
            TARGET       = L_TARGET,
            YEAR         = L_YEAR,
            UPDATED_DATE = CURRENT_DATE
        WHERE ID = L_SCORECARD_PROVIDER_ID;

    else
        --NVL(MAX(CodigoImpacto),0)+1
        --select scorecard_provider_seq.nextval into L_SCORECARD_PROVIDER_ID from dual;
        L_SCORECARD_PROVIDER_ID := scorecard_provider_seq.nextval;
        INSERT INTO SCORECARD.SCORECARD_PROVIDER (ID,
                                                  NAME,
                                                  LAST_SCORE,
                                                  BEFORE_SCORE,
                                                  TOTAL_AVG,
                                                  TARGET,
                                                  YEAR,
                                                  CREATED_DATE,
                                                  PROVEEDORES_ID,
                                                  STATUS,
                                                  MONTH)
            --select NVL(MAX(id),0)+1,
        values( L_SCORECARD_PROVIDER_ID, --SCORECARD_PROVIDER_SEQ.nextval,
                L_NAME,
                L_TOTAL_AVG,--L_LAST_SCORE,
                L_TOTAL_AVG,--L_BEFORE_SCORE,
                L_TOTAL_AVG,
                L_TARGET,
                p_year,
                CURRENT_DATE,
                p_provider_id,
                'NO INICIADO',
                p_month)
        --from SCORECARD.SCORECARD_PROVIDER
        ;
    end if;

    OPEN cur_score_cate(p_provider_id, p_month, p_year);
    LOOP
        FETCH  cur_score_cate INTO L_MONTH,L_YEAR,
            L_NAME,L_NOMBRE_AREA,L_NOMBRE_CATEGORIA,L_PROVEEDORES_ID,L_ID_AREA,L_ID_CATEGORIA,
            L_LAST_SCORE;
        EXIT WHEN cur_score_cate%NOTFOUND OR cur_score_cate%NOTFOUND IS NULL;


        open cur_score_area(p_provider_id, p_month, p_year,L_ID_AREA);--nota agrupada de las categorias al area
        FETCH cur_score_area INTO L_LAST_SCORE_AREA;
        CLOSE cur_score_area;

        --insert into log values ('*****');
        INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID,
                                                        MONTH,
                                                        SCORE,
                                                        BEFORE_SCORE,
                                                        SCORE_CATEGORY,
                                                        BEFORE_SCORE_CATEGORY,
                                                        CREATED_DATE,
                                                        SCORECARD_PROVIDER_ID,
                                                        ESTADO,
                                                        NOMBRE_AREA,
                                                        NOMBRE_CATEGORIA,
                                                        ID_AREA,ID_CATEGORIA)
        VALUES (scorecard_provider_month_seq.nextval,
                L_MONTH,
                L_LAST_SCORE_AREA,
                L_LAST_SCORE_AREA,
                L_LAST_SCORE,
                L_LAST_SCORE,
                CURRENT_DATE,
                L_SCORECARD_PROVIDER_ID,
                'NO INICIADO',
                L_NOMBRE_AREA,
                L_NOMBRE_CATEGORIA,
                L_ID_AREA,L_ID_CATEGORIA);

    END LOOP;
    close cur_score_cate;

END pc_create_up_scorecard;
/
