ALTER TABLE EVALUACION_DET MODIFY CREATED_BY NVARCHAR2(50) DEFAULT NULL;
ALTER TABLE EVALUACION_DET MODIFY UPDATED_BY NVARCHAR2(50) DEFAULT NULL;

ALTER TABLE USERS ADD first_name varchar2(100) NULL;
ALTER TABLE USERS ADD last_name varchar2(100) NULL;
ALTER TABLE PROVEEDORES RENAME COLUMN EVALUACION_ID TO KPI_ID;

create table NOTIFICATION_TEMPLATE
(
  ID         NUMBER(19) not null
    primary key,
  CREATED_BY VARCHAR2(30 char),
  CREATED_ON TIMESTAMP(6),
  UPDATED_BY VARCHAR2(30 char),
  UPDATED_ON TIMESTAMP(6),
  VERSION    NUMBER(19),
  BODY       LONG,
  NAME       VARCHAR2(255 char),
  SCOPE      NUMBER(10),
  STATUS     NUMBER(5),
  SUBJECT    VARCHAR2(255 char),
  TYPE       VARCHAR2(20 char)
)


-- -----------------------------------------
CREATE TABLE scorecard_provider (
                                    id               NUMBER NOT NULL,
                                    name             NVARCHAR2(100),
                                    last_note        NUMBER(5, 2),
                                    before_note      NUMBER(5, 2),
                                    total_avg        NUMBER(5, 2),
                                    target           NUMBER(5),
                                    year             NVARCHAR2(10),
                                    created_date     DATE,
                                    updated_date     DATE,
                                    proveedores_id   INTEGER NOT NULL
);

ALTER TABLE scorecard_provider ADD CONSTRAINT scorecard_provider_pk PRIMARY KEY ( id );

ALTER TABLE scorecard_provider
    ADD CONSTRAINT scorecard_provider_prov_fk FOREIGN KEY ( proveedores_id )
        REFERENCES proveedores ( id );


CREATE TABLE scorecard_provider_month (
                                          id                      NUMBER NOT NULL,
                                          month                   NVARCHAR2(50),
                                          score                   NUMBER(5, 2),
                                          before_score            NUMBER(5, 2),
                                          created_date            DATE,
                                          updated_date            DATE,
                                          created_by              NVARCHAR2(50),
                                          scorecard_provider_id   NUMBER NOT NULL
);

ALTER TABLE scorecard_provider_month ADD CONSTRAINT scorecard_provider_month_pk PRIMARY KEY ( id );

ALTER TABLE scorecard_provider_month
    ADD CONSTRAINT scorecard_month_prov_fk FOREIGN KEY ( scorecard_provider_id )
        REFERENCES scorecard_provider ( id );
