create sequence PROVEEDORES_SEQ
    maxvalue 9999999999
/

create sequence USERS_SEQ
    maxvalue 9999999999
/

create sequence KPIS_SEQ
    maxvalue 9999999999
/

create sequence CATEGORYS_SEQ
    maxvalue 9999999999
/

create sequence AREAS_SEQ
    maxvalue 9999999999
/

create sequence EV_DETAIL_SEQ
    maxvalue 9999999999
/

create sequence USERPROVEEDOR_SEQ
    maxvalue 9999999999
/

create sequence NOTIFICATION_SEQ
    maxvalue 9999999999
/

create sequence FILE_SEQ
    maxvalue 9999999999
/

create sequence EVALUACION_SEQ
    maxvalue 9999999999
/

create sequence EVALUACION_PROVEEDOR_SEQ
/

create sequence EVALUACION_DET_COMMENTS_SEQ
    maxvalue 9999999999
/

create sequence SCORECARD_PROVIDER_SEQ
    maxvalue 9999999999
/

create sequence EVALUACION_DET_SEQ
    maxvalue 9999999999
/

create sequence SCORECARD_PROVIDER_MONTH_SEQ
    maxvalue 9999999999
/

create sequence PLAN_ACCION_SEQ
    maxvalue 9999999999
/

create sequence PLAN_ACCION_SEQ_DET
    maxvalue 9999999999
/

create sequence PROVEEDORES_AGENDA_SEQ
    maxvalue 9999999999
/

create table PROVEEDORES
(
    ID                  NUMBER not null
        constraint TEST_PK
            primary key,
    CONTACTO            NVARCHAR2(50),
    EMAIL               NVARCHAR2(50),
    ESTADO              NVARCHAR2(50),
    EVALUACION_ACTUAL   NUMBER(12, 2),
    EVALUACION_GLOBAL   NUMBER(12, 2),
    FECHA_CREACION      DATE,
    FECHA_ACTUALIZACION DATE,
    CREADO_POR          NVARCHAR2(50),
    TENDENCIA           NVARCHAR2(50),
    NOMBRE              NVARCHAR2(50),
    KPI_ID              NUMBER
)
/

create table ARCHIVOS
(
    ID           NUMBER not null
        constraint ARCHIVOS_PK
            primary key,
    NOMBRE       NVARCHAR2(100),
    RUTA         NVARCHAR2(200),
    TIPO_ARCHIVO NVARCHAR2(50),
    ENTIDAD      NVARCHAR2(50),
    ENTIDAD_ID   NUMBER
)
/

create table KPI
(
    ID           NUMBER         not null
        constraint KPI_PK
            primary key,
    NOMBRE       NVARCHAR2(100) not null,
    CREATED_DATE DATE,
    UPDATED_DATE TIMESTAMP(6)
)
/

create table AREAS
(
    ID           NUMBER not null
        constraint AREAS_PK
            primary key,
    NOMBRE       NVARCHAR2(100),
    META         NUMBER,
    CREATED_DATE DATE,
    CREATED_BY   NVARCHAR2(50),
    UPDATED_BY   NVARCHAR2(50),
    UPDATED_DATE DATE,
    KPI_ID       NUMBER not null
        constraint AREAS_KPI_FK
            references KPI
)
/

create table CATEGORIAS
(
    ID           NUMBER not null
        constraint CATEGORIAS_PK
            primary key,
    NOMBRE       NVARCHAR2(50),
    META_MENSUAL NUMBER,
    META_ANUAL   NUMBER,
    CREATED_DATE DATE,
    UPDATED_DATE DATE,
    CREATED_BY   NVARCHAR2(50),
    UPDATED_BY   NVARCHAR2(50),
    AREAS_ID     NUMBER not null
        constraint CATEGORIAS_AREAS_FK
            references AREAS
)
/

create table EVALUACION
(
    ID                      NUMBER not null
        constraint EVALUACION_PK
            primary key,
    META                    NUMBER not null,
    CALIFICACION            NUMBER(10, 2),
    ESTADO                  NVARCHAR2(50),
    YEAR                    NVARCHAR2(50),
    CALIFICACION_ANTERIOR   NUMBER(10, 2),
    TENDENCIA               NVARCHAR2(50),
    GLOBAL                  NUMBER(10, 2),
    CREATED_DATE            DATE,
    UPDATED_DATE            DATE,
    CREATED_BY              NVARCHAR2(50),
    UPDATED_BY              NVARCHAR2(50),
    PROVEEDORES_ID          NUMBER not null
        constraint EVALUACION_PROVEEDORES_FK
            references PROVEEDORES,
    AREAS_ID                NUMBER not null
        constraint EVALUACION_AREAS_FK
            references AREAS,
    EVALUACION_PROVEEDOR_ID NUMBER
)
/

create table EVALUACION_DET
(
    ID                    NUMBER not null
        constraint EVALUACION_DET_PK
            primary key,
    COMENTARIO            NVARCHAR2(50),
    CM_USER_UPDATE        NVARCHAR2(50),
    VISIBLE_PROVEEDOR     CHAR(1 char),
    CALIFICACION_ANTERIOR NUMBER(12, 2),
    CALIFICACION_ACTUAL   NUMBER(12, 2),
    CALIFICACION_GLOBAL   NUMBER(12, 2),
    MES                   DATE,
    CREATED_BY            NVARCHAR2(50) default NULL,
    UPDATED_BY            NVARCHAR2(50) default NULL,
    CREATED_DATE          DATE,
    UPDATED_DATE          DATE,
    EVALUACION_ID         NUMBER not null
        constraint EVALUACION_DET_EVALUACION_FK
            references EVALUACION,
    CATEGORIAS_ID         NUMBER not null
        constraint EVALUACION_DET_CATEGORIAS_FK
            references CATEGORIAS
)
/

create table EVALUACION_DET_COMMENTARIOS
(
    ID                  NUMBER not null
        constraint EVALUACION_DET_COMMENTARIOS_PK
            primary key,
    COMENTARIO          NVARCHAR2(300),
    CREATED_BY          NVARCHAR2(50),
    CREATED_DATE        DATE,
    UPDATED_BY          NVARCHAR2(50),
    CM_USUARIO_MODIFICO NVARCHAR2(50),
    UPDATED_DATE        DATE,
    EVALUACION_DET_ID   NUMBER not null
        constraint EVAL_DET_COMM_FK
            references EVALUACION_DET
)
/

create table PLAN_ACCION
(
    ID                 NUMBER not null
        constraint PLAN_ACCION_PK
            primary key,
    OBJETIVO           NVARCHAR2(200),
    ESTADO             NVARCHAR2(50),
    MES                DATE,
    CREATED_BY         NVARCHAR2(50),
    CREATED_DATE       DATE,
    UPDATED_BY         NVARCHAR2(50),
    UPDATED_DATE       DATE,
    FECHA_COMPROMISO   DATE,
    AVANCE_PROVEEDOR   NUMBER(12, 2),
    AVANCE_CM          NUMBER(12, 2),
    NOMBRE             VARCHAR2(100),
    PROVEEDOR_ID       NUMBER
        constraint PLAN_ACCION_PROVEE__FK
            references PROVEEDORES,
    TIENE_EVENTO_NUEVO NUMBER default NULL,
    MONTH              VARCHAR2(25),
    YEAR               VARCHAR2(25)
)
/

create table PLAN_ACCION_DET
(
    ID               NUMBER not null
        constraint PLAN_ACCION_DET_PK
            primary key,
    COMENTARIO       NVARCHAR2(300),
    CREATED_DATE     DATE,
    CREATED_BY       NVARCHAR2(50),
    UPDATED_BY       NVARCHAR2(50),
    ESTADO           NVARCHAR2(50),
    PLAN_ACCION_ID   NUMBER not null
        constraint PLAN_ACCION_DET_PLAN_ACCION_FK
            references PLAN_ACCION,
    DESCRIPCION      VARCHAR2(500),
    FECHA_COMPROMISO DATE,
    AVANCE           NUMBER(12, 2),
    NOMBRE           VARCHAR2(100)
)
/

create table PLAN_ACCION_COMMENTARIOS
(
    ID                  NUMBER not null
        constraint PLAN_ACCION_COMMENTARIOS_PK
            primary key,
    COMENTARIO          NVARCHAR2(300),
    CREATED_BY          NVARCHAR2(50),
    CREATED_DATE        DATE,
    UPDATED_BY          NVARCHAR2(50),
    CM_USUARIO_MODIFICO NVARCHAR2(50),
    UPDATED_DATE        DATE,
    PLAN_ACCION_DET_ID  NUMBER not null
        constraint PLAN_ACCION_DET_COM_FK
            references PLAN_ACCION_DET
)
/

create table ROLES_PERMISOS
(
    ID           NUMBER not null
        constraint ROLES_PERMISOS_PK
            primary key,
    ROLE_NAME    NVARCHAR2(50),
    DESCRIPCION  NVARCHAR2(100),
    CREATED_DATE DATE
)
/

create table USERS
(
    ID         NUMBER not null
        constraint USERS_PK
            primary key,
    USER_NAME  NVARCHAR2(50),
    PASSWORD   NVARCHAR2(200),
    USER_TYPE  NVARCHAR2(100),
    EMAIL      NVARCHAR2(100),
    STATUS     CHAR,
    ENABLED    CHAR,
    FIRST_NAME VARCHAR2(100),
    LAST_NAME  VARCHAR2(100)
)
/

create table USERS_PROVEEDORES
(
    ID             NUMBER not null
        constraint USERS_PROVEEDORES_PK
            primary key,
    CREATED_DATE   DATE,
    UPDATED_DATE   DATE,
    PROVEEDORES_ID NUMBER not null
        constraint USERS_PROVES_PROVE_FK
            references PROVEEDORES,
    USERS_ID       NUMBER not null
        constraint USERS_PROVEEDORES_USERS_FK
            references USERS
)
/

create table USERS_ROLES
(
    ID                NUMBER not null
        constraint USERS_ROLES_PK
            primary key,
    ROLES_PERMISOS_ID NUMBER not null
        constraint USERS_ROLES_ROLES_PERMISOS_FK
            references ROLES_PERMISOS,
    USERS_ID          NUMBER not null
        constraint USERS_ROLES_USERS_FK
            references USERS
)
/

create table NOTIFICATION_TEMPLATE
(
    ID         NUMBER(19) not null
        primary key,
    CREATED_BY VARCHAR2(30 char),
    CREATED_ON TIMESTAMP(6),
    UPDATED_BY VARCHAR2(30 char),
    UPDATED_ON TIMESTAMP(6),
    VERSION    NUMBER(19),
    BODY       LONG,
    NAME       VARCHAR2(255 char),
    SCOPE      NUMBER(10),
    STATUS     NUMBER(5),
    SUBJECT    VARCHAR2(255 char),
    TYPE       VARCHAR2(20 char)
)
/

create table FILE_ITEM
(
    ID           NUMBER(19)         not null
        primary key,
    BUCKET_NAME  VARCHAR2(255 char),
    CREATED_BY   VARCHAR2(255 char) not null,
    CREATED_DATE TIMESTAMP(6)       not null,
    DESCRIPTION  VARCHAR2(255 char),
    ENTITY_TYPE  VARCHAR2(255 char) not null,
    FILE_NAME    VARCHAR2(255 char),
    FILE_PATH    VARCHAR2(255 char),
    FILE_SIZE    NUMBER(19),
    IDENTIFIER   NUMBER(19)         not null,
    IS_PUBLIC    NUMBER(1) default NULL,
    MIME_TYPE    VARCHAR2(255 char),
    SCOPE        VARCHAR2(255 char) not null
)
/

create table EVALUACION_PROVEEDOR
(
    ID                    NUMBER(19, 2) not null
        primary key,
    CALIFICACION          NUMBER(19, 2),
    CALIFICACION_ANTERIOR NUMBER(19, 2),
    CREATED_BY            VARCHAR2(255 char),
    CREATED_DATE          TIMESTAMP(6),
    ESTADO                VARCHAR2(255 char),
    GLOBAL                NUMBER(19, 2),
    META                  NUMBER(19, 2) not null,
    MONTH                 VARCHAR2(255 char),
    TENDENCIA             VARCHAR2(255 char),
    UPDATED_BY            VARCHAR2(255 char),
    UPDATED_DATE          TIMESTAMP(6),
    YEAR                  VARCHAR2(255 char),
    AREAS_ID              NUMBER(19)    not null
)
/

create table SCORECARD_PROVIDER
(
    ID             NUMBER not null
        constraint SCORECARD_PROVIDER_PK
            primary key,
    NAME           NVARCHAR2(100),
    LAST_SCORE     NUMBER(5, 2),
    BEFORE_SCORE   NUMBER(5, 2),
    TOTAL_AVG      NUMBER(5, 2),
    TARGET         NUMBER(5),
    YEAR           NVARCHAR2(10),
    CREATED_DATE   DATE,
    UPDATED_DATE   DATE,
    PROVEEDORES_ID NUMBER not null
        constraint SCORECARD_PROVIDER_PROV_FK
            references PROVEEDORES,
    MONTH          VARCHAR2(15),
    STATUS         VARCHAR2(50)
)
/

create table SCORECARD_PROVIDER_MONTH
(
    ID                    NUMBER not null
        constraint SCORECARD_PROVIDER_MONTH_PK
            primary key,
    MONTH                 NVARCHAR2(50),
    SCORE                 NUMBER(5, 2),
    BEFORE_SCORE          NUMBER(5, 2),
    CREATED_DATE          DATE,
    UPDATED_DATE          DATE,
    CREATED_BY            NVARCHAR2(50),
    SCORECARD_PROVIDER_ID NUMBER not null
        constraint SCORECARD_MONTH_PROV_FK
            references SCORECARD_PROVIDER,
    SCORE_CATEGORY        NUMBER(5, 2),
    BEFORE_SCORE_CATEGORY NUMBER(5, 2),
    NOMBRE_CATEGORIA      VARCHAR2(100),
    NOMBRE_AREA           VARCHAR2(100),
    ESTADO                VARCHAR2(50),
    ID_AREA               NUMBER,
    ID_CATEGORIA          NUMBER
)
/

create table LOG
(
    LINE NVARCHAR2(100)
)
/

create table SCORECARD_PROVIDER_COMMENTS
(
    ID                    NUMBER default NULL not null
        constraint SCORECARD_PROVIDER_COMMENTS_PK
            primary key,
    COMMENTS              VARCHAR2(1000),
    CREATED_DATE          DATE,
    CREATED_USER          VARCHAR2(50),
    SCORECARD_PROVIDER_ID NUMBER
        constraint SCORE_PRO_COMMS_FK
            references SCORECARD_PROVIDER
)
/

create table PROVEEDOR_AGENDA
(
    ID                   NUMBER not null
        primary key,
    TITULO               NVARCHAR2(200),
    OBJETIVO             NVARCHAR2(200),
    ES_RELEVANTE         NUMBER,
    ATENDERA_PROVEEDOR   NUMBER,
    FECHA_REUNION_INICIO DATE,
    FECHA_REUNION_FIN    DATE,
    CREATED_BY           NVARCHAR2(50),
    CREATED_DATE         DATE,
    UPDATED_BY           NVARCHAR2(100),
    PROVEEDOR_ID         NUMBER
        constraint PROV_AGENDA_PROV_ID_FK
            references PROVEEDORES,
    YEAR                 NUMBER,
    ESTADO               NVARCHAR2(30),
    MINUTA               NVARCHAR2(500)
)
/

create table AUTHORITIES
(
    ID        NUMBER not null
        primary key,
    USERNAME  NVARCHAR2(50),
    AUTHORITY NVARCHAR2(100)
)
/

create PROCEDURE dashboard_generateScoreYear(pid_evaluacion IN  NUMBER,
                                             result_code    OUT NUMBER)
AS


    paa_id INT := 0;


    CURSOR c1 IS

        SELECT e.id     AS id_evaluacion,
               e.meta   AS meta_evaluacion,
               e.CALIFICACION,
               e.CALIFICACION_ANTERIOR,
               a.id     AS id_area,
               a.nombre AS nombre_area,
               a.meta      meta_area,
               a.kpi_id,
               k.NOMBRE AS nombre_kpi,
               c.id     AS id_categoria,
               c.nombre AS nombre_categoria
        FROM EVALUACION e
                 JOIN areas a ON e.AREAS_ID = a.ID
                 JOIN kpi k ON a.KPI_ID = k.id
                 LEFT JOIN categorias c ON a.id = c.AREAS_ID;

BEGIN

    result_code := 0;


    FOR custom IN c1
        LOOP

            FOR i IN 1..11
                LOOP
                    INSERT INTO EVALUACION_DET (ID,
                                                COMENTARIO,
                                                CM_USER_UPDATE,
                                                VISIBLE_PROVEEDOR,
                                                CALIFICACION_ANTERIOR,
                                                CALIFICACION_ACTUAL,
                                                CALIFICACION_GLOBAL,
                                                MES,
                                                CREATED_BY,
                                                UPDATED_BY,
                                                CREATED_DATE,
                                                UPDATED_DATE,
                                                EVALUACION_ID,
                                                CATEGORIAS_ID)
                    VALUES (EV_DETAIL_SEQ.nextval,
                            'inicial',
                            'admin',
                            's',
                            4.00,
                            5.00,
                            6.00,
                            TO_DATE('2019-' || i || '-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'),
                            'admin',
                            'admin',
                            current_date,
                            current_date,
                            custom.id_evaluacion,
                            custom.id_categoria);
                END LOOP;

        END LOOP;

    result_code := 0;

    -- COMMIT;

EXCEPTION WHEN OTHERS
    THEN
        result_code := -1;
        ROLLBACK;
        RAISE;


END;
/

create PROCEDURE dash_global_by_kpi_month(pid_kpi     IN  NUMBER,
                                          pmes        IN  NUMBER,
                                          result_code OUT NUMBER)
AS

BEGIN

    result_code := 0;


    MERGE INTO evaluacion_det orig
    USING (SELECT k.id AS                                   kpi_id,
                  k.nombre                                  kpi_nombre,
                  e.id                                      eval_id,
                  e.CALIFICACION,
                  e.global,
                  e.AREAS_ID,
                  a.nombre                                  area_nombre,
                  a.meta,
                  c.ID AS                                   categorias_id,
                  c.nombre                                  cat_nombre,
                  c.META_MENSUAL,
                  (ed.CALIFICACION_ACTUAL / c.META_MENSUAL) global_categoria,
                  ed.ID                                     detail_id,
                  to_number(EXTRACT(MONTH FROM ed.mes), 99) mes_number,
                  ed.CALIFICACION_ANTERIOR,
                  ed.CALIFICACION_ACTUAL,
                  ed.CALIFICACION_GLOBAL,
                  ed.mes                                    fecha
           FROM EVALUACION_DET ed
                    JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                    JOIN areas a ON e.AREAS_ID = a.id
                    JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                    JOIN kpi k ON a.KPI_ID = k.id AND k.id = pid_kpi
           WHERE to_number(EXTRACT(MONTH FROM ed.mes), 99) = pmes) detail
    ON (orig.id = detail.detail_id)
    WHEN MATCHED THEN UPDATE SET orig.CALIFICACION_GLOBAL = detail.global_categoria;

    COMMIT;

EXCEPTION
    WHEN OTHERS
        THEN
            result_code := -1;
            ROLLBACK;
            RAISE;


END;
/

create PROCEDURE dash_global_by_kpi(pid_kpi     IN  NUMBER,
                                    result_code OUT NUMBER)
AS


    paa_id INT := 0;


BEGIN

    result_code := 0;


    MERGE INTO evaluacion_det orig
    USING (SELECT k.id AS                                   kpi_id,
                  k.nombre                                  kpi_nombre,
                  e.id                                      eval_id,
                  e.CALIFICACION,
                  e.global,
                  e.AREAS_ID,
                  a.nombre                                  area_nombre,
                  a.meta,
                  c.ID AS                                   categorias_id,
                  c.nombre                                  cat_nombre,
                  c.META_MENSUAL,
                  (ed.CALIFICACION_ACTUAL / c.META_MENSUAL) global_categoria,
                  ed.ID                                     detail_id,
                  to_number(EXTRACT(MONTH FROM ed.mes), 99) mes_number,
                  ed.CALIFICACION_ANTERIOR,
                  ed.CALIFICACION_ACTUAL,
                  ed.CALIFICACION_GLOBAL,
                  ed.mes                                    fecha
           FROM EVALUACION_DET ed
                    JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                    JOIN areas a ON e.AREAS_ID = a.id
                    JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                    JOIN kpi k ON a.KPI_ID = k.id
               AND k.id = pid_kpi) detail
    ON (orig.id = detail.detail_id)
    WHEN MATCHED THEN UPDATE SET orig.CALIFICACION_GLOBAL = detail.global_categoria;

    COMMIT;

EXCEPTION WHEN OTHERS
    THEN
        result_code := -1;
        ROLLBACK;
        RAISE;


END;
/

create PROCEDURE d_eval_global_month(pid_kpi     IN  NUMBER, pmes IN NUMBER,
                                     result_code OUT NUMBER)
AS


    paa_id INT := 0;


BEGIN

    result_code := 0;

    MERGE INTO evaluacion orig
    USING (SELECT k.id id_kpi, e.id id_eval, a.id, avg(ed.CALIFICACION_GLOBAL) AS average
           FROM EVALUACION_DET ed
                    JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                    JOIN areas a ON e.AREAS_ID = a.id
                    JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                    JOIN kpi k ON a.KPI_ID = k.id
               AND k.id = pid_kpi
           WHERE to_number(EXTRACT(MONTH FROM ed.mes), 99) = pmes
           GROUP BY k.id, e.id, a.id, to_number(EXTRACT(MONTH FROM ed.mes), 99)) detail
    ON (orig.id = detail.id_eval)
    WHEN MATCHED THEN UPDATE SET orig.GLOBAL = detail.average;

    COMMIT;

EXCEPTION WHEN OTHERS
    THEN
        result_code := -1;
        ROLLBACK;
        RAISE;

END;
/

create PROCEDURE get_detail_month(pkpi_id IN NUMBER, pmes IN NUMBER, p_cursor IN OUT SYS_REFCURSOR)
AS
BEGIN
    OPEN p_cursor FOR
        SELECT k.id AS                                   kpi_id,
               k.nombre                                  kpi_nombre,
               e.id                                      eval_id,
               e.global                                  global_actual,
               e.AREAS_ID,
               a.nombre                                  area_nombre,
               c.ID AS                                   categorias_id,
               c.nombre                                  cat_nombre,
               c.META_MENSUAL,
               (ed.CALIFICACION_ACTUAL / c.META_MENSUAL) global_categoria,
               ed.ID                                     detail_id,
               to_number(EXTRACT(MONTH FROM ed.mes), 99) mes_number,
               ed.CALIFICACION_ACTUAL,
               ed.CALIFICACION_GLOBAL
        FROM EVALUACION_DET ed
                 JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                 JOIN areas a ON e.AREAS_ID = a.id
                 JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                 JOIN kpi k ON a.KPI_ID = k.id AND k.id = pkpi_id
        WHERE to_number(EXTRACT(MONTH FROM ed.mes), 99) = pmes
        ORDER BY k.id, e.id, a.id, c.id, to_number(EXTRACT(MONTH FROM ed.mes), 99);

END;
/

create PROCEDURE get_detail_global(pkpi_id IN NUMBER, p_cursor IN OUT SYS_REFCURSOR)
AS
BEGIN
    OPEN p_cursor FOR
        SELECT k.id AS                                   kpi_id,
               k.nombre                                  kpi_nombre,
               e.id                                      eval_id,
               e.global                                  global_actual,
               e.AREAS_ID,
               a.nombre                                  area_nombre,
               c.ID AS                                   categorias_id,
               c.nombre                                  cat_nombre,
               c.META_MENSUAL,
               (ed.CALIFICACION_ACTUAL / c.META_MENSUAL) global_categoria,
               ed.ID                                     detail_id,
               to_number(EXTRACT(MONTH FROM ed.mes), 99) mes_number,
               ed.CALIFICACION_ACTUAL,
               ed.CALIFICACION_GLOBAL
        FROM EVALUACION_DET ed
                 JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                 JOIN areas a ON e.AREAS_ID = a.id
                 JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                 JOIN kpi k ON a.KPI_ID = k.id AND k.id = pkpi_id
        ORDER BY k.id, e.id, a.id, c.id, to_number(EXTRACT(MONTH FROM ed.mes), 99);

END;
/

create PROCEDURE get_detail_global_month(pkpi_id IN NUMBER, p_cursor IN OUT SYS_REFCURSOR)
AS
BEGIN
    OPEN p_cursor FOR
        SELECT kpi_id, mes, avg(promedio_area) AS promedio
        FROM (SELECT k.id AS                                   kpi_id,
                     e.id                                      eval_id,
                     a.id                                      areas_id,
                     to_number(EXTRACT(MONTH FROM ed.mes), 99) mes,
                     avg(ed.CALIFICACION_GLOBAL)               promedio_area
              FROM EVALUACION_DET ed
                       JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                       JOIN areas a ON e.AREAS_ID = a.id
                       JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                       JOIN kpi k ON a.KPI_ID = k.id AND k.id = pkpi_id
              GROUP BY k.id, e.id, a.id, to_number(EXTRACT(MONTH FROM ed.mes), 99))
        GROUP BY kpi_id, mes
        ORDER BY kpi_id, mes;

END;
/

create PROCEDURE pc_create_up_scorecard(p_provider_id IN PROVEEDORES.ID%TYPE,
                                        p_year        IN SCORECARD_PROVIDER.YEAR%TYPE,
                                        p_month       IN SCORECARD_PROVIDER_MONTH.MONTH%TYPE)
    IS
    -- area
--type acursor is ref cursor;
--cur_score_area  acursor;

    CURSOR cur_score_cate (p_provider_id IN scorecard_PROVIDER.PROVEEDORES_ID%TYPE,
        p_month IN SCORECARD_PROVIDER_MONTH.MONTH%TYPE,
        p_year IN scorecard_PROVIDER.YEAR%TYPE) is
        SELECT to_number(EXTRACT(MONTH FROM ed.mes), 99)  mes,
               to_number(EXTRACT(YEAR FROM ed.mes), 9999) YEAR,
               p.NOMBRE,
               a.NOMBRE,
               c.NOMBRE,
               p.id,
               a.ID,
               c.id,
               avg(ed.CALIFICACION_ACTUAL)                promedio_area
               -- INTO           L_MONTH, L_YEAR, L_NAME, L_PROVEEDORES_ID, L_LAST_SCORE
        FROM EVALUACION_DET ed
                 JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                 JOIN areas a ON e.AREAS_ID = a.id
                 JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                 JOIN kpi k ON a.KPI_ID = k.id
                 JOIN PROVEEDORES P on e.PROVEEDORES_ID = P.ID
        WHERE p.id = p_provider_id
          AND to_number(EXTRACT(MONTH FROM ed.mes), 99) = p_month
          AND to_number(EXTRACT(year FROM ed.mes), 9999) = p_year
        GROUP BY k.id, e.id, a.id, c.id, p.nombre, a.nombre, c.nombre, p.id, to_number(EXTRACT(MONTH FROM ed.mes), 99),
                 to_number(EXTRACT(YEAR FROM ed.mes), 9999)
        order by mes;

    --   -- por area nota total de todas las areas agrupadas por categoria
    CURSOR cur_score_area (
        p_provider_id scorecard_PROVIDER.PROVEEDORES_ID%TYPE,
        p_month SCORECARD_PROVIDER_MONTH.MONTH%TYPE,
        p_year scorecard_PROVIDER.YEAR%TYPE,
        p_area_id IN scorecard_PROVIDER.YEAR%TYPE) is
        SELECT avg(ed.CALIFICACION_ACTUAL)
        FROM EVALUACION_DET ed
                 JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                 JOIN areas a ON e.AREAS_ID = a.id
                 JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                 JOIN PROVEEDORES P on e.PROVEEDORES_ID = P.ID
        WHERE p.id = p_provider_id
          AND to_number(EXTRACT(MONTH FROM ed.mes), 99) = p_month
          AND to_number(EXTRACT(year FROM ed.mes), 9999) = p_year
          and a.id = p_area_id
    --group by ed.id
    --   GROUP BY c.id, p.nombre,c.nombre, p.id, to_number(EXTRACT(MONTH FROM ed.mes), 99),
    --            to_number(EXTRACT(YEAR FROM ed.mes), 9999)
    ;

    --   p.NOMBRE,a.NOMBRE,c.nombre catname,
    --          p.id,

    --global
    CURSOR cur_score_global (p_provider_id scorecard_PROVIDER.PROVEEDORES_ID%TYPE,
        p_month SCORECARD_PROVIDER_MONTH.MONTH%TYPE,
        p_year scorecard_PROVIDER.YEAR%TYPE) is
        select -- mes, YEAR, NOMBRE, provedorId,
               -- categoria_id,
               avg(promedio_categoria), NOMBRE
               -- INTO L_TOTAL_AVG
        from (SELECT e.id                                       eval_id,
                     c.id                                       categoria_id,
                     to_number(EXTRACT(MONTH FROM ed.mes), 99)  mes,
                     to_number(EXTRACT(YEAR FROM ed.mes), 9999) YEAR,
                     p.NOMBRE,
                     p.id                                       provedorId,
                     avg(ed.CALIFICACION_ACTUAL)                promedio_categoria
              FROM EVALUACION_DET ed
                       JOIN EVALUACION e ON ed.EVALUACION_ID = e.id
                       JOIN categorias c ON ed.CATEGORIAS_ID = c.id
                       JOIN PROVEEDORES P on e.PROVEEDORES_ID = P.ID
              where p.id = p_provider_id
                and to_number(EXTRACT(MONTH FROM ed.mes), 99) = p_month
                AND to_number(EXTRACT(year FROM ed.mes), 9999) = p_year
              GROUP BY e.id, c.id, p.nombre, p.id, to_number(EXTRACT(MONTH FROM ed.mes), 99),
                       to_number(EXTRACT(YEAR FROM ed.mes), 9999))
        group by YEAR, NOMBRE, provedorId; --mes,

    CURSOR cur_score_year (
        p_provider_id scorecard_PROVIDER.PROVEEDORES_ID%TYPE,
        p_month IN SCORECARD_PROVIDER_MONTH.MONTH%TYPE,
        p_year scorecard_PROVIDER.YEAR%TYPE) is
        select p.id, p.LAST_SCORE
        from SCORECARD.SCORECARD_PROVIDER p
        where p.PROVEEDORES_ID = p_provider_id
          and p.YEAR = p_year
          and p.MONTH = p_month;

    CURSOR cur_quiz_comments
        (p_provider_id scorecard_PROVIDER.PROVEEDORES_ID%TYPE,
        p_month SCORECARD_PROVIDER_MONTH.MONTH%TYPE,
        p_year scorecard_PROVIDER.YEAR%TYPE)
        is
        select d.id, d.comentario, d.CREATED_DATE, d.CREATED_BY
        from EVALUACION_DET_COMMENTARIOS d
                 join evaluacion_det e on e.id = d.EVALUACION_DET_ID
                 join evaluacion x on x.id = e.EVALUACION_ID
            and x.PROVEEDORES_ID = p_provider_id
            and to_number(EXTRACT(MONTH FROM e.mes), 99) = p_month
            AND to_number(EXTRACT(year FROM e.mes), 9999) = p_year;


    L_NAME            scorecard_PROVIDER.NAME%TYPE;
    L_LAST_SCORE_AREA SCORECARD_PROVIDER_MONTH.SCORE%TYPE;
    L_LAST_SCORE      scorecard_PROVIDER.LAST_SCORE%TYPE; -- CATGORIAS
    L_BEFORE_SCORE    scorecard_PROVIDER.BEFORE_SCORE%TYPE;
    L_TOTAL_AVG       scorecard_PROVIDER.TOTAL_AVG%TYPE;
    L_TARGET                scorecard_PROVIDER.TARGET%TYPE := 5;
    L_YEAR                  scorecard_PROVIDER.YEAR%TYPE := p_year;
    L_CREATED_DATE          scorecard_PROVIDER.CREATED_DATE%TYPE;
    L_PROVEEDORES_ID        scorecard_PROVIDER.PROVEEDORES_ID%TYPE := p_provider_id;
    L_SCORECARD_PROVIDER    SCORECARD_PROVIDER.PROVEEDORES_ID%TYPE;
    L_MONTH                 SCORECARD_PROVIDER_MONTH.MONTH%TYPE := p_month;
    L_SCORECARD_PROVIDER_ID SCORECARD_PROVIDER.ID%TYPE;
    L_NOMBRE_AREA           scorecard_PROVIDER_MONTH.NOMBRE_AREA%TYPE;
    L_NOMBRE_CATEGORIA      scorecard_PROVIDER_MONTH.NOMBRE_CATEGORIA%TYPE;
    L_ID_AREA               AREAS.ID%TYPE;
    L_ID_CATEGORIA         CATEGORIAS.ID%TYPE;
    L_COMMENT              EVALUACION_DET_COMMENTARIOS.COMENTARIO%TYPE;
    L_COMMENT_ID           EVALUACION_DET_COMMENTARIOS.ID%TYPE;
    L_COMMENT_CREATED_DATE EVALUACION_DET_COMMENTARIOS.CREATED_DATE%TYPE;
    L_CREATED_BY           EVALUACION_DET_COMMENTARIOS.CREATED_BY%TYPE;

    --d.comentario,d.CREATED_DATE,x.PROVEEDORES_ID,e.MES

BEGIN
    --DBMS_OUTPUT.ENABLE (buffer_size IN INTEGER DEFAULT 20000);

    OPEN cur_score_global(p_provider_id, p_month, p_year);
    FETCH cur_score_global INTO L_TOTAL_AVG, L_NAME;
    CLOSE cur_score_global;

    OPEN cur_score_year(p_provider_id, p_month, p_year);
    FETCH cur_score_year INTO L_SCORECARD_PROVIDER_ID, L_LAST_SCORE;

    CLOSE cur_score_year;


    if L_SCORECARD_PROVIDER_ID > 0
    then
        UPDATE SCORECARD.SCORECARD_PROVIDER
        SET NAME         = L_NAME,
            LAST_SCORE   = L_TOTAL_AVG, --L_LAST_SCORE,
            BEFORE_SCORE = L_BEFORE_SCORE,
            TOTAL_AVG    = L_TOTAL_AVG,
            TARGET       = L_TARGET,
            YEAR         = L_YEAR,
            UPDATED_DATE = CURRENT_DATE
        WHERE ID = L_SCORECARD_PROVIDER_ID;

    else
        --NVL(MAX(CodigoImpacto),0)+1
        --select scorecard_provider_seq.nextval into L_SCORECARD_PROVIDER_ID from dual;
        L_SCORECARD_PROVIDER_ID := scorecard_provider_seq.nextval;
        INSERT INTO SCORECARD.SCORECARD_PROVIDER (ID,
                                                  NAME,
                                                  LAST_SCORE,
                                                  BEFORE_SCORE,
                                                  TOTAL_AVG,
                                                  TARGET,
                                                  YEAR,
                                                  CREATED_DATE,
                                                  PROVEEDORES_ID,
                                                  STATUS,
                                                  MONTH)
            --select NVL(MAX(id),0)+1,
        values (L_SCORECARD_PROVIDER_ID, --SCORECARD_PROVIDER_SEQ.nextval,
                L_NAME, L_TOTAL_AVG, --L_LAST_SCORE,
                L_TOTAL_AVG, --L_BEFORE_SCORE,
                L_TOTAL_AVG, L_TARGET, p_year, CURRENT_DATE, p_provider_id, 'NO INICIADO', p_month)
        --from SCORECARD.SCORECARD_PROVIDER
        ;
    end if;

    OPEN cur_score_cate(p_provider_id, p_month, p_year);
    LOOP
        FETCH cur_score_cate INTO L_MONTH, L_YEAR,
            L_NAME, L_NOMBRE_AREA, L_NOMBRE_CATEGORIA, L_PROVEEDORES_ID, L_ID_AREA, L_ID_CATEGORIA,
            L_LAST_SCORE;
        EXIT WHEN cur_score_cate%NOTFOUND OR cur_score_cate%NOTFOUND IS NULL;


        open cur_score_area(p_provider_id, p_month, p_year, L_ID_AREA); --nota agrupada de las categorias al area
        FETCH cur_score_area INTO L_LAST_SCORE_AREA;
        CLOSE cur_score_area;

        --insert into log values ('*****');
        INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID,
                                                        MONTH,
                                                        SCORE,
                                                        BEFORE_SCORE,
                                                        SCORE_CATEGORY,
                                                        BEFORE_SCORE_CATEGORY,
                                                        CREATED_DATE,
                                                        SCORECARD_PROVIDER_ID,
                                                        ESTADO,
                                                        NOMBRE_AREA,
                                                        NOMBRE_CATEGORIA,
                                                        ID_AREA,
                                                        ID_CATEGORIA)
        VALUES (scorecard_provider_month_seq.nextval,
                L_MONTH,
                L_LAST_SCORE_AREA,
                L_LAST_SCORE_AREA,
                L_LAST_SCORE,
                L_LAST_SCORE,
                CURRENT_DATE,
                L_SCORECARD_PROVIDER_ID,
                'NO INICIADO',
                L_NOMBRE_AREA,
                L_NOMBRE_CATEGORIA,
                L_ID_AREA,
                L_ID_CATEGORIA);

    END LOOP;
    close cur_score_cate;

    OPEN cur_quiz_comments(p_provider_id, p_month, p_year);
    LOOP
        FETCH cur_quiz_comments INTO L_COMMENT_ID, L_COMMENT, L_COMMENT_CREATED_DATE, L_CREATED_BY;

        EXIT WHEN cur_quiz_comments%NOTFOUND OR cur_quiz_comments%NOTFOUND IS NULL;

        INSERT INTO SCORECARD.SCORECARD_PROVIDER_COMMENTS (ID,
                                                           COMMENTS,
                                                           CREATED_DATE,
                                                           CREATED_USER,
                                                           SCORECARD_PROVIDER_ID)
        VALUES (L_COMMENT_ID, L_COMMENT, L_COMMENT_CREATED_DATE, L_CREATED_BY, L_SCORECARD_PROVIDER_ID);

    END LOOP;
    CLOSE cur_quiz_comments;


END pc_create_up_scorecard;
/

create PROCEDURE GET_RESUME_SCORE_AREA(
    p_scoreprovider_id IN     SCORECARD_PROVIDER.ID%TYPE
                                      , p_cursor           IN OUT SYS_REFCURSOR)
    IS

BEGIN
    open p_cursor for
        select s.ID_AREA as idArea, s.nombre_area as name, s.score as score
        from scorecard_provider_month s
        where scorecard_provider_id = p_scoreprovider_id
        group by s.ID_AREA, s.nombre_area, s.score;


END GET_RESUME_SCORE_AREA;
/

create PROCEDURE GET_RESUME_LASTEST_MONTHS(
    p_provider_id IN     SCORECARD_PROVIDER.ID%TYPE
                                          , p_cursor      IN OUT SYS_REFCURSOR)
    IS

BEGIN
    open p_cursor for
        select p.MONTH as name, (p.TOTAL_AVG / 5 * 100) as score
        from scorecard_provider p
        where p.proveedores_id = p_provider_id
          and p.year = 2019
          and p.month > 0
        order by p.MONTH;
    --and p.status = 'APROBADO';


END GET_RESUME_LASTEST_MONTHS;
/

create PROCEDURE GET_SCOREPRO_CATEGORY_SCORES(
    p_scoreprovider_id IN     SCORECARD_PROVIDER.ID%TYPE,
    p_area_id          IN     SCORECARD_PROVIDER_MONTH.ID_AREA%TYPE,
    p_cursor           IN OUT SYS_REFCURSOR)
    IS

BEGIN
    open p_cursor for
        select s.NOMBRE_CATEGORIA as nombre, s.NOMBRE_CATEGORIA as name, s.SCORE_CATEGORY as score
        from scorecard_provider_month s
        where s.scorecard_provider_id = p_scoreprovider_id
          and s.ID_AREA = p_area_id;

    --and p.status = 'APROBADO';


END GET_SCOREPRO_CATEGORY_SCORES;
/



INSERT INTO SCORECARD.AREAS (ID, NOMBRE, META, CREATED_DATE, CREATED_BY, UPDATED_BY, UPDATED_DATE, KPI_ID) VALUES (4, 'Nuevo test ', 5, null, null, null, null, 24);
INSERT INTO SCORECARD.AREAS (ID, NOMBRE, META, CREATED_DATE, CREATED_BY, UPDATED_BY, UPDATED_DATE, KPI_ID) VALUES (5, 'Soporte de averias', 5, null, null, null, null, 4);
INSERT INTO SCORECARD.AREAS (ID, NOMBRE, META, CREATED_DATE, CREATED_BY, UPDATED_BY, UPDATED_DATE, KPI_ID) VALUES (6, 'Planificacion e instalaciones', 5, TO_DATE('2019-11-13 23:06:34', 'YYYY-MM-DD HH24:MI:SS'), null, 'admin', TO_DATE('2019-11-13 23:06:34', 'YYYY-MM-DD HH24:MI:SS'), 4);
INSERT INTO SCORECARD.AREAS (ID, NOMBRE, META, CREATED_DATE, CREATED_BY, UPDATED_BY, UPDATED_DATE, KPI_ID) VALUES (7, 'Manejo de Cuentas', 5, TO_DATE('2019-11-13 23:06:44', 'YYYY-MM-DD HH24:MI:SS'), null, 'admin', TO_DATE('2019-11-13 23:06:44', 'YYYY-MM-DD HH24:MI:SS'), 4);
INSERT INTO SCORECARD.AUTHORITIES (ID, USERNAME, AUTHORITY) VALUES (1, 'admin', 'ADMIN');
INSERT INTO SCORECARD.CATEGORIAS (ID, NOMBRE, META_MENSUAL, META_ANUAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, AREAS_ID) VALUES (16, 'categoria test', 10, 100, null, null, null, null, 4);
INSERT INTO SCORECARD.CATEGORIAS (ID, NOMBRE, META_MENSUAL, META_ANUAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, AREAS_ID) VALUES (4, 'Cumplimiento de Agenda', 5, 100, null, null, null, null, 5);
INSERT INTO SCORECARD.CATEGORIAS (ID, NOMBRE, META_MENSUAL, META_ANUAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, AREAS_ID) VALUES (5, 'Cumplimiento de SLAs', 5, 100, TO_DATE('2019-11-13 23:17:51', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-13 23:17:51', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', 5);
INSERT INTO SCORECARD.CATEGORIAS (ID, NOMBRE, META_MENSUAL, META_ANUAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, AREAS_ID) VALUES (6, 'Calidad de servicio de instalación', 5, 100, TO_DATE('2019-11-13 23:18:07', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-13 23:18:07', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', 5);
INSERT INTO SCORECARD.CATEGORIAS (ID, NOMBRE, META_MENSUAL, META_ANUAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, AREAS_ID) VALUES (7, 'Cumplimiento de agenda', 5, 100, TO_DATE('2019-11-13 23:18:57', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-13 23:18:57', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', 6);
INSERT INTO SCORECARD.CATEGORIAS (ID, NOMBRE, META_MENSUAL, META_ANUAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, AREAS_ID) VALUES (8, 'Calidad de instalación', 5, 100, TO_DATE('2019-11-13 23:19:06', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-13 23:19:06', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', 6);
INSERT INTO SCORECARD.CATEGORIAS (ID, NOMBRE, META_MENSUAL, META_ANUAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, AREAS_ID) VALUES (9, 'Desempeño en proyectos especiales', 5, 100, TO_DATE('2019-11-13 23:19:18', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-13 23:19:18', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', 6);
INSERT INTO SCORECARD.CATEGORIAS (ID, NOMBRE, META_MENSUAL, META_ANUAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, AREAS_ID) VALUES (10, 'Cumplimiento de procesos', 5, 100, TO_DATE('2019-11-13 23:20:30', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-13 23:20:30', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', 7);
INSERT INTO SCORECARD.CATEGORIAS (ID, NOMBRE, META_MENSUAL, META_ANUAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, AREAS_ID) VALUES (11, 'Disposición en problemas', 5, 100, TO_DATE('2019-11-13 23:20:32', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-13 23:20:32', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', 7);
INSERT INTO SCORECARD.CATEGORIAS (ID, NOMBRE, META_MENSUAL, META_ANUAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, AREAS_ID) VALUES (12, 'Manejo de inventarios', 5, 100, TO_DATE('2019-11-13 23:20:34', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-13 23:20:34', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', 7);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (1, 100, 10.00, '1', '2019', 5.00, '7', 7.00, TO_DATE('2019-11-13 20:14:39', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-13 20:14:39', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', 4, 5, null);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (2, 100, 10.00, '1', '2019', 5.00, '7', 7.00, TO_DATE('2019-11-14 01:33:46', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:33:46', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', 4, 6, null);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (3, 100, 10.00, '1', '2019', 5.00, '7', 7.00, TO_DATE('2019-11-14 01:33:52', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:33:52', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', 4, 7, null);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (6, 5, null, 'INICIAL', null, null, null, null, TO_DATE('2019-12-18 19:52:42', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 8);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (7, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 19:55:04', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 9);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (8, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 19:56:43', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 10);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (9, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 20:11:36', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 11);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (10, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 20:13:10', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 12);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (11, 0, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 20:13:10', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 12);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (12, 0, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 20:13:11', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 12);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (13, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 13);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (14, 0, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 13);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (15, 0, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 13);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (16, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 14);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (17, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 14);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (18, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 14);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (19, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 21:38:55', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 15);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (20, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 16);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (21, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 16);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (22, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 16);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (23, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 17);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (24, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 17);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (25, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 17);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (26, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-19 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 18);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (27, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-19 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 18);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (28, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-19 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 18);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (29, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-19 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 19);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (30, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-19 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 19);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (31, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-19 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 19);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (32, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-19 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 20);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (33, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-19 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 20);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (34, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-19 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 20);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (35, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-19 01:05:10', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 21);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (36, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-19 01:05:11', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 21);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (37, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-19 01:05:11', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 21);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (38, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-20 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 22);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (39, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-20 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 22);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (40, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-20 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 22);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (41, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-24 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 23);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (42, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-24 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 23);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (43, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-24 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 23);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (44, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-24 18:25:24', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 24);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (45, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-24 18:25:24', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 24);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (46, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2019-12-24 18:26:32', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 25);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (47, 5, null, 'INICIAL', '2018', null, null, null, TO_DATE('2019-12-24 18:30:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 26);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (48, 5, null, 'INICIAL', '2018', null, null, null, TO_DATE('2019-12-24 18:55:16', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 27);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (49, 5, null, 'INICIAL', '2018', null, null, null, TO_DATE('2019-12-24 18:57:12', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 28);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (64, 5, null, 'INICIAL', '2018', null, null, null, TO_DATE('2019-12-24 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 41);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (65, 5, null, 'INICIAL', '2018', null, null, null, TO_DATE('2019-12-24 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 41);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (66, 5, null, 'INICIAL', '2018', null, null, null, TO_DATE('2019-12-24 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 41);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (84, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2020-01-04 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 61);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (85, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2020-01-04 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 61);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (86, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2020-01-04 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 61);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (87, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2020-01-04 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 62);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (88, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2020-01-04 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 62);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (89, 5, null, 'INICIAL', '2019', null, null, null, TO_DATE('2020-01-04 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 62);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (90, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-04 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 63);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (91, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-04 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 63);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (92, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-04 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 63);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (93, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-05 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 64);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (94, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-05 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 64);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (95, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-05 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 64);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (96, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 65);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (97, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 65);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (98, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 65);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (99, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 66);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (100, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 66);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (101, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 66);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (102, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 67);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (103, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 67);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (104, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 67);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (105, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 68);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (106, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 68);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (107, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 68);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (108, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 00:52:26', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 69);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (109, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 00:52:26', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 69);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (110, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 00:52:27', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 69);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (111, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 70);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (112, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 70);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (113, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 70);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (114, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 01:06:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 71);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (115, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 71);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (116, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 71);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (117, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 5, 72);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (118, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 6, 72);
INSERT INTO SCORECARD.EVALUACION (ID, META, CALIFICACION, ESTADO, YEAR, CALIFICACION_ANTERIOR, TENDENCIA, GLOBAL, CREATED_DATE, UPDATED_DATE, CREATED_BY, UPDATED_BY, PROVEEDORES_ID, AREAS_ID, EVALUACION_PROVEEDOR_ID) VALUES (119, 5, null, 'INICIAL', '2020', null, null, null, TO_DATE('2020-01-08 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 4, 7, 72);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (124, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-05-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (125, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-06-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (126, 'inicial', 'admin', 's', 4.00, 3.00, 0.60, TO_DATE('2019-07-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (127, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-08-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (128, 'inicial', 'admin', 's', 4.00, 1.00, 0.20, TO_DATE('2019-09-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (129, 'inicial', 'admin', 's', 4.00, 3.00, 0.60, TO_DATE('2019-10-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (130, 'inicial', 'admin', 's', 4.00, 5.00, 1.00, TO_DATE('2019-11-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (131, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-01-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (132, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-02-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (133, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-03-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (134, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-04-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (135, 'inicial', 'admin', 's', 4.00, 1.00, 0.20, TO_DATE('2019-05-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (136, 'inicial', 'admin', 's', 4.00, 3.00, 0.60, TO_DATE('2019-06-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (137, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-07-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (138, 'inicial', 'admin', 's', 4.00, 5.00, 1.00, TO_DATE('2019-08-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (139, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-09-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (140, 'inicial', 'admin', 's', 4.00, 1.00, 0.20, TO_DATE('2019-10-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (141, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-11-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (142, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-01-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (143, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-02-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (144, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-03-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (145, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-04-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (146, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-05-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (147, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-06-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (148, 'inicial', 'admin', 's', 4.00, 1.00, 0.20, TO_DATE('2019-07-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (5, null, null, null, null, null, null, TO_DATE('2020-01-01 20:13:10', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 20:13:10', 'YYYY-MM-DD HH24:MI:SS'), null, 10, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (6, null, null, null, null, null, null, TO_DATE('2020-01-01 20:13:10', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 20:13:10', 'YYYY-MM-DD HH24:MI:SS'), null, 10, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (7, null, null, null, null, null, null, TO_DATE('2020-01-01 20:13:10', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 20:13:10', 'YYYY-MM-DD HH24:MI:SS'), null, 10, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (8, null, null, null, null, null, null, TO_DATE('2020-01-01 20:13:10', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 20:13:10', 'YYYY-MM-DD HH24:MI:SS'), null, 11, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (9, null, null, null, null, null, null, TO_DATE('2020-01-01 20:13:11', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 20:13:11', 'YYYY-MM-DD HH24:MI:SS'), null, 11, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (10, null, null, null, null, null, null, TO_DATE('2020-01-01 20:13:11', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 20:13:11', 'YYYY-MM-DD HH24:MI:SS'), null, 11, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (11, null, null, null, null, null, null, TO_DATE('2020-01-01 20:13:11', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 20:13:11', 'YYYY-MM-DD HH24:MI:SS'), null, 12, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (12, null, null, null, null, null, null, TO_DATE('2020-01-01 20:13:11', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 20:13:11', 'YYYY-MM-DD HH24:MI:SS'), null, 12, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (13, null, null, null, null, null, null, TO_DATE('2020-01-01 20:13:11', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 20:13:11', 'YYYY-MM-DD HH24:MI:SS'), null, 12, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (14, null, null, null, null, null, null, TO_DATE('2020-01-01 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, 13, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (15, null, null, null, null, null, null, TO_DATE('2020-01-01 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, 13, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (16, null, null, null, null, null, null, TO_DATE('2020-01-01 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, 13, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (17, null, null, null, null, null, null, TO_DATE('2020-01-01 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, 14, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (18, null, null, null, null, null, null, TO_DATE('2020-01-01 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, 14, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (19, null, null, null, null, null, null, TO_DATE('2020-01-01 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, 14, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (20, null, null, null, null, null, null, TO_DATE('2020-01-01 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, 15, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (21, null, null, null, null, null, null, TO_DATE('2020-01-01 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, 15, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (22, null, null, null, null, null, null, TO_DATE('2020-01-01 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 20:15:49', 'YYYY-MM-DD HH24:MI:SS'), null, 15, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (23, null, null, null, null, null, null, TO_DATE('2020-01-01 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, 16, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (24, null, null, null, null, null, null, TO_DATE('2020-01-01 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, 16, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (25, null, null, null, null, null, null, TO_DATE('2020-01-01 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, 16, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (26, null, null, null, null, null, null, TO_DATE('2020-01-01 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, 17, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (27, null, null, null, null, null, null, TO_DATE('2020-01-01 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, 17, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (28, null, null, null, null, null, null, TO_DATE('2020-01-01 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, 17, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (29, null, null, null, null, null, null, TO_DATE('2020-01-01 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, 18, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (30, null, null, null, null, null, null, TO_DATE('2020-01-01 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, 18, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (31, null, null, null, null, null, null, TO_DATE('2020-01-01 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:09:14', 'YYYY-MM-DD HH24:MI:SS'), null, 18, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (32, null, null, null, null, null, null, TO_DATE('2020-01-01 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, 20, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (33, null, null, null, null, null, null, TO_DATE('2020-01-01 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, 20, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (34, null, null, null, null, null, null, TO_DATE('2020-01-01 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, 20, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (35, null, null, null, null, null, null, TO_DATE('2020-01-01 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, 21, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (36, null, null, null, null, null, null, TO_DATE('2020-01-01 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, 21, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (37, null, null, null, null, null, null, TO_DATE('2020-01-01 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, 21, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (38, null, null, null, null, null, null, TO_DATE('2020-01-01 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, 22, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (39, null, null, null, null, null, null, TO_DATE('2020-01-01 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, 22, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (40, null, null, null, null, null, null, TO_DATE('2020-01-01 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, 22, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (41, null, null, null, null, null, null, TO_DATE('2020-01-01 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, 23, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (42, null, null, null, null, null, null, TO_DATE('2020-01-01 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, 23, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (43, null, null, null, null, null, null, TO_DATE('2020-01-01 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, 23, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (44, null, null, null, null, null, null, TO_DATE('2020-01-01 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, 24, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (45, null, null, null, null, null, null, TO_DATE('2020-01-01 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, 24, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (46, null, null, null, null, null, null, TO_DATE('2020-01-01 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, 24, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (47, null, null, null, null, null, null, TO_DATE('2020-01-01 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, 25, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (48, null, null, null, null, null, null, TO_DATE('2020-01-01 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, 25, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (49, null, null, null, null, null, null, TO_DATE('2020-01-01 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, 25, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (50, null, null, null, null, null, null, TO_DATE('2020-01-01 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, 26, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (51, null, null, null, null, null, null, TO_DATE('2020-01-01 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, 26, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (52, null, null, null, null, null, null, TO_DATE('2020-01-01 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, 26, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (53, null, null, null, null, null, null, TO_DATE('2020-01-01 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, 27, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (54, null, null, null, null, null, null, TO_DATE('2020-01-01 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, 27, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (55, null, null, null, null, null, null, TO_DATE('2020-01-01 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, 27, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (56, null, null, null, null, null, null, TO_DATE('2020-01-01 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, 28, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (57, null, null, null, null, null, null, TO_DATE('2020-01-01 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, 28, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (58, null, null, null, null, null, null, TO_DATE('2020-01-01 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 00:52:34', 'YYYY-MM-DD HH24:MI:SS'), null, 28, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (59, null, null, null, null, null, null, TO_DATE('2020-01-01 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, 29, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (60, null, null, null, null, null, null, TO_DATE('2020-01-01 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, 29, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (61, null, null, null, null, null, null, TO_DATE('2020-01-01 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, 29, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (62, null, null, null, null, null, null, TO_DATE('2020-01-01 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, 30, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (63, null, null, null, null, null, null, TO_DATE('2020-01-01 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, 30, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (64, null, null, null, null, null, null, TO_DATE('2020-01-01 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, 30, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (65, null, null, null, null, null, null, TO_DATE('2020-01-01 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, 31, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (66, null, null, null, null, null, null, TO_DATE('2020-01-01 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, 31, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (67, null, null, null, null, null, null, TO_DATE('2020-01-01 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 00:55:15', 'YYYY-MM-DD HH24:MI:SS'), null, 31, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (68, null, null, null, null, null, null, TO_DATE('2020-01-01 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, 32, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (69, null, null, null, null, null, null, TO_DATE('2020-01-01 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, 32, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (70, null, null, null, null, null, null, TO_DATE('2020-01-01 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, 32, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (71, null, null, null, null, null, null, TO_DATE('2020-01-01 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, 33, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (72, null, null, null, null, null, null, TO_DATE('2020-01-01 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, 33, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (73, null, null, null, null, null, null, TO_DATE('2020-01-01 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, 33, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (74, null, null, null, null, null, null, TO_DATE('2020-01-01 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, 34, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (75, null, null, null, null, null, null, TO_DATE('2020-01-01 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, 34, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (76, null, null, null, null, null, null, TO_DATE('2020-01-01 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 01:03:49', 'YYYY-MM-DD HH24:MI:SS'), null, 34, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (77, null, null, null, null, null, null, TO_DATE('2020-01-01 01:05:10', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 01:05:10', 'YYYY-MM-DD HH24:MI:SS'), null, 35, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (78, null, null, null, null, null, null, TO_DATE('2020-01-01 01:05:10', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 01:05:10', 'YYYY-MM-DD HH24:MI:SS'), null, 35, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (79, null, null, null, null, null, null, TO_DATE('2020-01-01 01:05:10', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 01:05:10', 'YYYY-MM-DD HH24:MI:SS'), null, 35, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (80, null, null, null, null, null, null, TO_DATE('2020-01-01 01:05:11', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 01:05:11', 'YYYY-MM-DD HH24:MI:SS'), null, 36, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (81, null, null, null, null, null, null, TO_DATE('2020-01-01 01:05:11', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 01:05:11', 'YYYY-MM-DD HH24:MI:SS'), null, 36, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (82, null, null, null, null, null, null, TO_DATE('2020-01-01 01:05:11', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 01:05:11', 'YYYY-MM-DD HH24:MI:SS'), null, 36, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (83, null, null, null, null, null, null, TO_DATE('2020-01-01 01:05:11', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 01:05:11', 'YYYY-MM-DD HH24:MI:SS'), null, 37, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (84, null, null, null, null, null, null, TO_DATE('2020-01-01 01:05:11', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 01:05:11', 'YYYY-MM-DD HH24:MI:SS'), null, 37, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (85, null, null, null, null, null, null, TO_DATE('2020-01-01 01:05:11', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-19 01:05:11', 'YYYY-MM-DD HH24:MI:SS'), null, 37, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (86, null, null, null, null, null, null, TO_DATE('2020-01-01 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-20 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, 38, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (87, null, null, null, null, null, null, TO_DATE('2020-01-01 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-20 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, 38, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (88, null, null, null, null, null, null, TO_DATE('2020-01-01 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-20 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, 38, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (89, null, null, null, null, null, null, TO_DATE('2020-01-01 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-20 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, 39, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (90, null, null, null, null, null, null, TO_DATE('2020-01-01 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-20 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, 39, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (91, null, null, null, null, null, null, TO_DATE('2020-01-01 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-20 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, 39, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (92, null, null, null, null, null, null, TO_DATE('2020-01-01 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-20 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, 40, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (93, null, null, null, null, null, null, TO_DATE('2020-01-01 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-20 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, 40, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (94, null, null, null, null, null, null, TO_DATE('2020-01-01 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-20 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, 40, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (95, null, null, null, null, null, null, TO_DATE('2020-01-01 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, 41, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (96, null, null, null, null, null, null, TO_DATE('2020-01-01 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, 41, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (97, null, null, null, null, null, null, TO_DATE('2020-01-01 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, 41, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (98, null, null, null, null, null, null, TO_DATE('2020-01-01 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, 42, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (99, null, null, null, null, null, null, TO_DATE('2020-01-01 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, 42, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (100, null, null, null, null, null, null, TO_DATE('2020-01-01 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, 42, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (101, null, null, null, null, null, null, TO_DATE('2020-01-01 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, 43, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (102, null, null, null, null, null, null, TO_DATE('2020-01-01 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, 43, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (103, null, null, null, null, null, null, TO_DATE('2020-01-01 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 18:18:56', 'YYYY-MM-DD HH24:MI:SS'), null, 43, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (104, null, null, null, null, null, null, TO_DATE('2020-01-01 18:25:24', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 18:25:24', 'YYYY-MM-DD HH24:MI:SS'), null, 44, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (105, null, null, null, null, null, null, TO_DATE('2020-01-01 18:25:24', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 18:25:24', 'YYYY-MM-DD HH24:MI:SS'), null, 44, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (106, null, null, null, null, null, null, TO_DATE('2020-01-01 18:25:24', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 18:25:24', 'YYYY-MM-DD HH24:MI:SS'), null, 44, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (107, null, null, null, null, null, null, TO_DATE('2020-01-01 18:25:24', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 18:25:24', 'YYYY-MM-DD HH24:MI:SS'), null, 45, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (108, null, null, null, null, null, null, TO_DATE('2020-01-01 18:25:24', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 18:25:24', 'YYYY-MM-DD HH24:MI:SS'), null, 45, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (208, null, null, null, null, null, null, TO_DATE('2018-08-01 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, 64, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (209, null, null, null, null, null, null, TO_DATE('2018-08-01 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, 64, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (210, null, null, null, null, null, null, TO_DATE('2018-08-01 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, 64, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (211, null, null, null, null, null, null, TO_DATE('2018-08-01 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, 65, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (212, null, null, null, null, null, null, TO_DATE('2018-08-01 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, 65, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (213, null, null, null, null, null, null, TO_DATE('2018-08-01 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, 65, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (214, null, null, null, null, null, null, TO_DATE('2018-08-01 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, 66, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (215, null, null, null, null, null, null, TO_DATE('2018-08-01 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, 66, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (216, null, null, null, null, null, null, TO_DATE('2018-08-01 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2019-12-24 19:59:25', 'YYYY-MM-DD HH24:MI:SS'), null, 66, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (228, null, null, null, null, null, null, TO_DATE('2020-01-01 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-04 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, 84, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (229, null, null, null, null, null, null, TO_DATE('2020-01-01 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-04 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, 84, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (230, null, null, null, null, null, null, TO_DATE('2020-01-01 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-04 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, 84, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (231, null, null, null, null, null, null, TO_DATE('2020-01-01 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-04 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, 85, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (232, null, null, null, null, null, null, TO_DATE('2020-01-01 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-04 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, 85, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (233, null, null, null, null, null, null, TO_DATE('2020-01-01 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-04 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, 85, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (234, null, null, null, null, null, null, TO_DATE('2020-01-01 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-04 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, 86, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (235, null, null, null, null, null, null, TO_DATE('2020-01-01 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-04 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, 86, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (236, null, null, null, null, null, null, TO_DATE('2020-01-01 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-04 22:03:18', 'YYYY-MM-DD HH24:MI:SS'), null, 86, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (164, 'inicial', 'admin', 's', 4.00, 1.00, 0.20, TO_DATE('2019-01-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (165, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-02-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (166, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-03-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (167, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-04-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (168, 'inicial', 'admin', 's', 4.00, 3.00, 0.60, TO_DATE('2019-05-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (169, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-06-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (170, 'inicial', 'admin', 's', 4.00, 1.00, 0.20, TO_DATE('2019-07-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (171, 'inicial', 'admin', 's', 4.00, 1.00, 0.20, TO_DATE('2019-08-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (172, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-09-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (173, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-10-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (174, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-11-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (175, 'inicial', 'admin', 's', 4.00, 5.00, 1.00, TO_DATE('2019-01-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (176, 'inicial', 'admin', 's', 4.00, 3.00, 0.60, TO_DATE('2019-02-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (177, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-03-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (178, 'inicial', 'admin', 's', 4.00, 3.00, 0.60, TO_DATE('2019-04-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (179, 'inicial', 'admin', 's', 4.00, 1.00, 0.20, TO_DATE('2019-05-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (180, 'inicial', 'admin', 's', 4.00, 3.00, 0.60, TO_DATE('2019-06-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (181, 'inicial', 'admin', 's', 4.00, 5.00, 1.00, TO_DATE('2019-07-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (182, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-08-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (109, 'inicial', 'admin', 's', 4.00, 3.00, 0.60, TO_DATE('2019-01-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (110, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-02-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (111, 'inicial', 'admin', 's', 4.00, 1.00, 0.20, TO_DATE('2019-03-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (112, 'inicial', 'admin', 's', 4.00, 3.00, 0.60, TO_DATE('2019-04-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (113, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-05-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (114, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-06-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (115, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-07-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (116, 'inicial', 'admin', 's', 4.00, 5.00, 1.00, TO_DATE('2019-08-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (117, 'inicial', 'admin', 's', 4.00, 5.00, 1.00, TO_DATE('2019-09-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (118, 'inicial', 'admin', 's', 4.00, 1.00, 0.20, TO_DATE('2019-10-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (119, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-11-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (120, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-01-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (121, 'inicial', 'admin', 's', 4.00, 1.00, 0.20, TO_DATE('2019-02-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (122, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-03-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (123, 'inicial', 'admin', 's', 4.00, 3.00, 0.60, TO_DATE('2019-04-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 1, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (183, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-09-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (184, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-10-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (185, 'inicial', 'admin', 's', 4.00, 3.00, 0.60, TO_DATE('2019-11-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (186, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-01-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (187, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-02-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (188, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-03-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (189, 'inicial', 'admin', 's', 4.00, 3.00, 0.60, TO_DATE('2019-04-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (190, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-05-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (191, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-06-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (192, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-07-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (193, 'inicial', 'admin', 's', 4.00, 5.00, 1.00, TO_DATE('2019-08-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (194, 'inicial', 'admin', 's', 4.00, 3.00, 0.60, TO_DATE('2019-09-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (195, 'inicial', 'admin', 's', 4.00, 1.00, 0.20, TO_DATE('2019-10-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (196, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-11-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (197, 'inicial', 'admin', 's', 4.00, 3.00, 0.60, TO_DATE('2019-01-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (198, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-02-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (199, 'inicial', 'admin', 's', 4.00, 1.00, 0.20, TO_DATE('2019-03-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (200, 'inicial', 'admin', 's', 4.00, 5.00, 1.00, TO_DATE('2019-04-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (201, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-05-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (202, 'inicial', 'admin', 's', 4.00, 1.00, 0.20, TO_DATE('2019-06-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (203, 'inicial', 'admin', 's', 4.00, 1.00, 0.20, TO_DATE('2019-07-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (204, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-08-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (205, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-09-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (206, 'inicial', 'admin', 's', 4.00, 1.00, 0.20, TO_DATE('2019-10-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (207, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-11-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 3, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (149, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-08-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (150, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-09-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (151, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-10-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (152, 'inicial', 'admin', 's', 4.00, 5.00, 1.00, TO_DATE('2019-11-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (153, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-01-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (154, 'inicial', 'admin', 's', 4.00, 3.00, 0.60, TO_DATE('2019-02-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (155, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-03-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (156, 'inicial', 'admin', 's', 4.00, 5.00, 1.00, TO_DATE('2019-04-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (157, 'inicial', 'admin', 's', 4.00, 1.00, 0.20, TO_DATE('2019-05-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (158, 'inicial', 'admin', 's', 4.00, 5.00, 1.00, TO_DATE('2019-06-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (159, 'inicial', 'admin', 's', 4.00, 3.00, 0.60, TO_DATE('2019-07-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (160, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-08-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (161, 'inicial', 'admin', 's', 4.00, 2.00, 0.40, TO_DATE('2019-09-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (162, 'inicial', 'admin', 's', 4.00, 4.00, 0.80, TO_DATE('2019-10-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (163, 'inicial', 'admin', 's', 4.00, 5.00, 1.00, TO_DATE('2019-11-25 19:00:00', 'YYYY-MM-DD HH24:MI:SS'), 'admin', 'admin', TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-14 01:46:41', 'YYYY-MM-DD HH24:MI:SS'), 2, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (237, null, null, null, null, null, null, TO_DATE('2020-01-01 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-04 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, 87, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (238, null, null, null, null, null, null, TO_DATE('2020-01-01 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-04 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, 87, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (239, null, null, null, null, null, null, TO_DATE('2020-01-01 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-04 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, 87, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (240, null, null, null, null, null, null, TO_DATE('2020-01-01 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-04 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, 88, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (241, null, null, null, null, null, null, TO_DATE('2020-01-01 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-04 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, 88, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (242, null, null, null, null, 3.00, null, TO_DATE('2020-01-01 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-04 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, 88, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (243, null, null, null, null, 2.00, null, TO_DATE('2020-01-01 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-04 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, 89, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (244, null, null, null, null, 1.00, null, TO_DATE('2020-01-01 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-04 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, 89, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (245, null, null, null, null, 5.00, null, TO_DATE('2020-01-01 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-04 22:28:17', 'YYYY-MM-DD HH24:MI:SS'), null, 89, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (246, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), null, 'admincmchange', TO_DATE('2020-01-04 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2020-01-08 13:26:25', 'YYYY-MM-DD HH24:MI:SS'), 90, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (247, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), null, 'admincmchange', TO_DATE('2020-01-04 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2020-01-08 13:26:25', 'YYYY-MM-DD HH24:MI:SS'), 90, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (248, null, null, null, null, 3.00, null, TO_DATE('2020-04-01 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), null, 'admincmchange', TO_DATE('2020-01-04 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2020-01-08 13:26:25', 'YYYY-MM-DD HH24:MI:SS'), 90, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (249, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), null, 'admincmchange', TO_DATE('2020-01-04 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2020-01-08 13:26:25', 'YYYY-MM-DD HH24:MI:SS'), 91, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (250, null, null, null, null, 5.00, null, TO_DATE('2020-04-01 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), null, 'admincmchange', TO_DATE('2020-01-04 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2020-01-08 13:26:25', 'YYYY-MM-DD HH24:MI:SS'), 91, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (251, null, null, null, null, 4.00, null, TO_DATE('2020-04-01 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), null, 'admincmchange', TO_DATE('2020-01-04 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2020-01-08 13:26:25', 'YYYY-MM-DD HH24:MI:SS'), 91, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (252, null, null, null, null, 3.00, null, TO_DATE('2020-04-01 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), null, 'admincmchange', TO_DATE('2020-01-04 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2020-01-08 13:26:25', 'YYYY-MM-DD HH24:MI:SS'), 92, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (253, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), null, 'admincmchange', TO_DATE('2020-01-04 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2020-01-08 13:26:25', 'YYYY-MM-DD HH24:MI:SS'), 92, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (254, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), null, 'admincmchange', TO_DATE('2020-01-04 22:52:08', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2020-01-08 13:26:25', 'YYYY-MM-DD HH24:MI:SS'), 92, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (255, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-05 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, 93, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (256, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-05 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, 93, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (257, null, null, null, null, 3.00, null, TO_DATE('2020-04-01 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-05 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, 93, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (258, null, null, null, null, 4.00, null, TO_DATE('2020-04-01 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-05 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, 94, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (259, null, null, null, null, 5.00, null, TO_DATE('2020-04-01 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-05 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, 94, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (260, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-05 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, 94, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (261, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-05 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, 95, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (262, null, null, null, null, 3.00, null, TO_DATE('2020-04-01 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-05 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, 95, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (263, null, null, null, null, 4.00, null, TO_DATE('2020-04-01 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-05 21:14:39', 'YYYY-MM-DD HH24:MI:SS'), null, 95, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (264, null, null, null, null, 4.00, null, TO_DATE('2020-04-01 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, 96, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (265, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, 96, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (266, null, null, null, null, 3.00, null, TO_DATE('2020-04-01 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, 96, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (267, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, 97, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (268, null, null, null, null, 5.00, null, TO_DATE('2020-04-01 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, 97, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (269, null, null, null, null, 4.00, null, TO_DATE('2020-04-01 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, 97, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (270, null, null, null, null, 3.00, null, TO_DATE('2020-04-01 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, 98, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (271, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, 98, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (272, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:46:13', 'YYYY-MM-DD HH24:MI:SS'), null, 98, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (273, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, 99, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (274, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, 99, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (275, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, 99, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (276, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, 100, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (277, null, null, null, null, 5.00, null, TO_DATE('2020-04-01 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, 100, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (278, null, null, null, null, 4.00, null, TO_DATE('2020-04-01 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, 100, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (279, null, null, null, null, 3.00, null, TO_DATE('2020-04-01 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, 101, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (280, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, 101, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (281, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:47:15', 'YYYY-MM-DD HH24:MI:SS'), null, 101, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (282, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, 102, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (283, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, 102, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (284, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, 102, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (285, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, 103, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (286, null, null, null, null, 5.00, null, TO_DATE('2020-04-01 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, 103, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (287, null, null, null, null, 4.00, null, TO_DATE('2020-04-01 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, 103, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (288, null, null, null, null, 3.00, null, TO_DATE('2020-04-01 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, 104, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (289, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, 104, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (290, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:48:19', 'YYYY-MM-DD HH24:MI:SS'), null, 104, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (291, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, 105, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (292, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, 105, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (293, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, 105, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (294, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, 106, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (295, null, null, null, null, 5.00, null, TO_DATE('2020-04-01 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, 106, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (296, null, null, null, null, 4.00, null, TO_DATE('2020-04-01 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, 106, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (297, null, null, null, null, 3.00, null, TO_DATE('2020-04-01 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, 107, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (298, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, 107, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (299, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:51:46', 'YYYY-MM-DD HH24:MI:SS'), null, 107, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (300, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 00:52:26', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:52:26', 'YYYY-MM-DD HH24:MI:SS'), null, 108, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (301, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 00:52:26', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:52:26', 'YYYY-MM-DD HH24:MI:SS'), null, 108, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (302, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 00:52:26', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:52:26', 'YYYY-MM-DD HH24:MI:SS'), null, 108, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (303, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 00:52:26', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:52:26', 'YYYY-MM-DD HH24:MI:SS'), null, 109, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (304, null, null, null, null, 5.00, null, TO_DATE('2020-04-01 00:52:27', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:52:27', 'YYYY-MM-DD HH24:MI:SS'), null, 109, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (305, null, null, null, null, 4.00, null, TO_DATE('2020-04-01 00:52:27', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:52:27', 'YYYY-MM-DD HH24:MI:SS'), null, 109, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (306, null, null, null, null, 3.00, null, TO_DATE('2020-04-01 00:52:27', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:52:27', 'YYYY-MM-DD HH24:MI:SS'), null, 110, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (307, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 00:52:27', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:52:27', 'YYYY-MM-DD HH24:MI:SS'), null, 110, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (308, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 00:52:27', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 00:52:27', 'YYYY-MM-DD HH24:MI:SS'), null, 110, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (309, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, 111, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (310, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, 111, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (311, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, 111, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (312, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, 112, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (313, null, null, null, null, 5.00, null, TO_DATE('2020-04-01 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, 112, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (314, null, null, null, null, 4.00, null, TO_DATE('2020-04-01 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, 112, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (315, null, null, null, null, 3.00, null, TO_DATE('2020-04-01 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, 113, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (316, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:02:19', 'YYYY-MM-DD HH24:MI:SS'), null, 113, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (317, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 01:02:20', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:02:20', 'YYYY-MM-DD HH24:MI:SS'), null, 113, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (318, null, null, null, null, 3.00, null, TO_DATE('2020-04-01 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, 114, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (319, null, null, null, null, 5.00, null, TO_DATE('2020-04-01 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, 114, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (320, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, 114, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (321, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, 115, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (322, null, null, null, null, 5.00, null, TO_DATE('2020-04-01 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, 115, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (323, null, null, null, null, 4.00, null, TO_DATE('2020-04-01 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, 115, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (324, null, null, null, null, 3.00, null, TO_DATE('2020-04-01 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, 116, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (325, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, 116, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (326, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:06:22', 'YYYY-MM-DD HH24:MI:SS'), null, 116, 12);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (327, null, null, null, null, 3.00, null, TO_DATE('2020-04-01 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, 117, 4);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (328, null, null, null, null, 5.00, null, TO_DATE('2020-04-01 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, 117, 5);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (329, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, 117, 6);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (330, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, 118, 7);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (331, null, null, null, null, 5.00, null, TO_DATE('2020-04-01 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, 118, 8);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (332, null, null, null, null, 4.00, null, TO_DATE('2020-04-01 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, 118, 9);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (333, null, null, null, null, 3.00, null, TO_DATE('2020-04-01 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, 119, 10);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (334, null, null, null, null, 2.00, null, TO_DATE('2020-04-01 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:08:57', 'YYYY-MM-DD HH24:MI:SS'), null, 119, 11);
INSERT INTO SCORECARD.EVALUACION_DET (ID, COMENTARIO, CM_USER_UPDATE, VISIBLE_PROVEEDOR, CALIFICACION_ANTERIOR, CALIFICACION_ACTUAL, CALIFICACION_GLOBAL, MES, CREATED_BY, UPDATED_BY, CREATED_DATE, UPDATED_DATE, EVALUACION_ID, CATEGORIAS_ID) VALUES (335, null, null, null, null, 1.00, null, TO_DATE('2020-04-01 01:08:58', 'YYYY-MM-DD HH24:MI:SS'), null, null, TO_DATE('2020-01-08 01:08:58', 'YYYY-MM-DD HH24:MI:SS'), null, 119, 12);
INSERT INTO SCORECARD.EVALUACION_DET_COMMENTARIOS (ID, COMENTARIO, CREATED_BY, CREATED_DATE, UPDATED_BY, CM_USUARIO_MODIFICO, UPDATED_DATE, EVALUACION_DET_ID) VALUES (5, '123', null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 32);
INSERT INTO SCORECARD.EVALUACION_DET_COMMENTARIOS (ID, COMENTARIO, CREATED_BY, CREATED_DATE, UPDATED_BY, CM_USUARIO_MODIFICO, UPDATED_DATE, EVALUACION_DET_ID) VALUES (6, '333', null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 32);
INSERT INTO SCORECARD.EVALUACION_DET_COMMENTARIOS (ID, COMENTARIO, CREATED_BY, CREATED_DATE, UPDATED_BY, CM_USUARIO_MODIFICO, UPDATED_DATE, EVALUACION_DET_ID) VALUES (7, '445', null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 33);
INSERT INTO SCORECARD.EVALUACION_DET_COMMENTARIOS (ID, COMENTARIO, CREATED_BY, CREATED_DATE, UPDATED_BY, CM_USUARIO_MODIFICO, UPDATED_DATE, EVALUACION_DET_ID) VALUES (8, '55', null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 33);
INSERT INTO SCORECARD.EVALUACION_DET_COMMENTARIOS (ID, COMENTARIO, CREATED_BY, CREATED_DATE, UPDATED_BY, CM_USUARIO_MODIFICO, UPDATED_DATE, EVALUACION_DET_ID) VALUES (9, '245fgt', 'adminchange', TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 41);
INSERT INTO SCORECARD.EVALUACION_DET_COMMENTARIOS (ID, COMENTARIO, CREATED_BY, CREATED_DATE, UPDATED_BY, CM_USUARIO_MODIFICO, UPDATED_DATE, EVALUACION_DET_ID) VALUES (10, 'yeerty', 'adminchange', TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 41);
INSERT INTO SCORECARD.EVALUACION_DET_COMMENTARIOS (ID, COMENTARIO, CREATED_BY, CREATED_DATE, UPDATED_BY, CM_USUARIO_MODIFICO, UPDATED_DATE, EVALUACION_DET_ID) VALUES (11, '454rghfgh', 'adminchange', TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 42);
INSERT INTO SCORECARD.EVALUACION_DET_COMMENTARIOS (ID, COMENTARIO, CREATED_BY, CREATED_DATE, UPDATED_BY, CM_USUARIO_MODIFICO, UPDATED_DATE, EVALUACION_DET_ID) VALUES (12, '353tgggrghrth', 'adminchange', TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 42);
INSERT INTO SCORECARD.EVALUACION_DET_COMMENTARIOS (ID, COMENTARIO, CREATED_BY, CREATED_DATE, UPDATED_BY, CM_USUARIO_MODIFICO, UPDATED_DATE, EVALUACION_DET_ID) VALUES (13, 'nuevos comentarios', 'adminchange', TO_DATE('2019-12-20 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 86);
INSERT INTO SCORECARD.EVALUACION_DET_COMMENTARIOS (ID, COMENTARIO, CREATED_BY, CREATED_DATE, UPDATED_BY, CM_USUARIO_MODIFICO, UPDATED_DATE, EVALUACION_DET_ID) VALUES (14, 'otro', 'adminchange', TO_DATE('2019-12-20 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 86);
INSERT INTO SCORECARD.EVALUACION_DET_COMMENTARIOS (ID, COMENTARIO, CREATED_BY, CREATED_DATE, UPDATED_BY, CM_USUARIO_MODIFICO, UPDATED_DATE, EVALUACION_DET_ID) VALUES (15, 'xyz', 'adminchange', TO_DATE('2019-12-20 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 87);
INSERT INTO SCORECARD.EVALUACION_DET_COMMENTARIOS (ID, COMENTARIO, CREATED_BY, CREATED_DATE, UPDATED_BY, CM_USUARIO_MODIFICO, UPDATED_DATE, EVALUACION_DET_ID) VALUES (1, 'testcomentarioNEW UPDATE', 'adminchange', TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), 'admincmchange', null, TO_DATE('2020-01-08 13:26:25', 'YYYY-MM-DD HH24:MI:SS'), 253);
INSERT INTO SCORECARD.EVALUACION_DET_COMMENTARIOS (ID, COMENTARIO, CREATED_BY, CREATED_DATE, UPDATED_BY, CM_USUARIO_MODIFICO, UPDATED_DATE, EVALUACION_DET_ID) VALUES (3672, 'test', 'admincmchange', TO_DATE('2020-01-08 13:26:25', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, 252);
INSERT INTO SCORECARD.EVALUACION_DET_COMMENTARIOS (ID, COMENTARIO, CREATED_BY, CREATED_DATE, UPDATED_BY, CM_USUARIO_MODIFICO, UPDATED_DATE, EVALUACION_DET_ID) VALUES (3671, 'testcomentarioUPDATE 123444', null, null, 'admincmchange', null, TO_DATE('2020-01-08 13:26:25', 'YYYY-MM-DD HH24:MI:SS'), 253);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (6.00, null, null, 'admin', TO_TIMESTAMP('2019-12-18 19:45:12.648000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, null, null, null, null, null, 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (7.00, null, null, 'admin', TO_TIMESTAMP('2019-12-18 19:47:48.898000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, null, null, null, null, null, 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (8.00, null, null, 'admin', TO_TIMESTAMP('2019-12-18 19:52:42.725000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, null, null, null, null, null, 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (9.00, null, null, 'admin', TO_TIMESTAMP('2019-12-18 19:55:04.870000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (10.00, null, null, 'admin', TO_TIMESTAMP('2019-12-18 19:56:43.054000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (11.00, null, null, 'admin', TO_TIMESTAMP('2019-12-18 20:11:36.628000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (12.00, null, null, 'admin', TO_TIMESTAMP('2019-12-18 20:13:10.710000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (13.00, null, null, 'admin', TO_TIMESTAMP('2019-12-18 20:15:48.957000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (14.00, null, null, 'admin', TO_TIMESTAMP('2019-12-18 21:09:14.232000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (15.00, null, null, 'admin', TO_TIMESTAMP('2019-12-18 21:38:55.133000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (16.00, null, null, 'admin', TO_TIMESTAMP('2019-12-18 21:43:39.353000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (17.00, null, null, 'admin', TO_TIMESTAMP('2019-12-18 21:47:29.285000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (18.00, null, null, 'admin', TO_TIMESTAMP('2019-12-19 00:52:34.535000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (19.00, null, null, 'admin', TO_TIMESTAMP('2019-12-19 00:55:15.725000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (20.00, null, null, 'admin', TO_TIMESTAMP('2019-12-19 01:03:49.024000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (21.00, null, null, 'admin', TO_TIMESTAMP('2019-12-19 01:05:10.949000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (22.00, null, null, 'admin', TO_TIMESTAMP('2019-12-20 12:07:41.169000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (23.00, null, null, 'admin', TO_TIMESTAMP('2019-12-24 18:18:56.676000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (24.00, null, null, 'admin', TO_TIMESTAMP('2019-12-24 18:25:24.096000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (25.00, null, null, 'admin', TO_TIMESTAMP('2019-12-24 18:26:32.543000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (26.00, null, null, 'admin', TO_TIMESTAMP('2019-12-24 18:30:19.680000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '7', null, null, null, '2018', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (27.00, null, null, 'admin', TO_TIMESTAMP('2019-12-24 18:55:16.618000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '7', null, null, null, '2018', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (28.00, null, null, 'admin', TO_TIMESTAMP('2019-12-24 18:57:12.657000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '7', null, null, null, '2018', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (41.00, null, null, 'admin', TO_TIMESTAMP('2019-12-24 19:59:25.229000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '7', null, null, null, '2018', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (61.00, null, null, null, TO_TIMESTAMP('2020-01-04 22:03:18.346000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (62.00, null, null, null, TO_TIMESTAMP('2020-01-04 22:28:17.373000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '12', null, null, null, '2019', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (63.00, null, null, 'admin', TO_TIMESTAMP('2020-01-04 22:52:08.152000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '3', null, null, null, '2020', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (64.00, null, null, null, TO_TIMESTAMP('2020-01-05 21:14:39.723000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '3', null, null, null, '2020', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (65.00, null, null, null, TO_TIMESTAMP('2020-01-08 00:46:13.316000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '3', null, null, null, '2020', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (66.00, null, null, null, TO_TIMESTAMP('2020-01-08 00:47:15.213000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '3', null, null, null, '2020', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (67.00, null, null, null, TO_TIMESTAMP('2020-01-08 00:48:19.082000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '3', null, null, null, '2020', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (68.00, null, null, null, TO_TIMESTAMP('2020-01-08 00:51:46.118000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '3', null, null, null, '2020', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (69.00, null, null, null, TO_TIMESTAMP('2020-01-08 00:52:26.869000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '3', null, null, null, '2020', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (70.00, null, null, null, TO_TIMESTAMP('2020-01-08 01:02:19.676000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '3', null, null, null, '2020', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (71.00, null, null, null, TO_TIMESTAMP('2020-01-08 01:06:21.929000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '3', null, null, null, '2020', 4);
INSERT INTO SCORECARD.EVALUACION_PROVEEDOR (ID, CALIFICACION, CALIFICACION_ANTERIOR, CREATED_BY, CREATED_DATE, ESTADO, GLOBAL, META, MONTH, TENDENCIA, UPDATED_BY, UPDATED_DATE, YEAR, AREAS_ID) VALUES (72.00, null, null, null, TO_TIMESTAMP('2020-01-08 01:08:57.800000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'INICIAL', null, 100.00, '3', null, null, null, '2020', 4);
INSERT INTO SCORECARD.FILE_ITEM (ID, BUCKET_NAME, CREATED_BY, CREATED_DATE, DESCRIPTION, ENTITY_TYPE, FILE_NAME, FILE_PATH, FILE_SIZE, IDENTIFIER, IS_PUBLIC, MIME_TYPE, SCOPE) VALUES (44, null, 'temp', TO_TIMESTAMP('2019-12-19 00:09:55.702000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'quizfiles', 'quiz', 'pdf_generator.log', 'com.tigo.files.pathpdf_generator.log', 87835, 4, 0, 'application/octet-stream', 'provider-quiz');
INSERT INTO SCORECARD.FILE_ITEM (ID, BUCKET_NAME, CREATED_BY, CREATED_DATE, DESCRIPTION, ENTITY_TYPE, FILE_NAME, FILE_PATH, FILE_SIZE, IDENTIFIER, IS_PUBLIC, MIME_TYPE, SCOPE) VALUES (18, null, 'temp', TO_TIMESTAMP('2019-12-09 00:51:20.153000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'welcomefile', 'provider', '213 (1).png', 'com.tigo.files.path213 (1).png', 133228, 4, 0, 'image/png', 'provider-welcome');
INSERT INTO SCORECARD.FILE_ITEM (ID, BUCKET_NAME, CREATED_BY, CREATED_DATE, DESCRIPTION, ENTITY_TYPE, FILE_NAME, FILE_PATH, FILE_SIZE, IDENTIFIER, IS_PUBLIC, MIME_TYPE, SCOPE) VALUES (45, null, 'temp', TO_TIMESTAMP('2019-12-19 00:11:59.582000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'quizfiles', 'quiz', 'events_sale_audit.log', 'com.tigo.files.pathevents_sale_audit.log', 158807, 4, 0, 'application/octet-stream', 'provider-quiz');
INSERT INTO SCORECARD.FILE_ITEM (ID, BUCKET_NAME, CREATED_BY, CREATED_DATE, DESCRIPTION, ENTITY_TYPE, FILE_NAME, FILE_PATH, FILE_SIZE, IDENTIFIER, IS_PUBLIC, MIME_TYPE, SCOPE) VALUES (46, null, 'temp', TO_TIMESTAMP('2019-12-19 01:05:30.042000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'quizfiles', 'quiz', 'pdf_generator.log', 'com.tigo.files.pathpdf_generator.log', 87835, 21, 0, 'application/octet-stream', 'provider-quiz');
INSERT INTO SCORECARD.FILE_ITEM (ID, BUCKET_NAME, CREATED_BY, CREATED_DATE, DESCRIPTION, ENTITY_TYPE, FILE_NAME, FILE_PATH, FILE_SIZE, IDENTIFIER, IS_PUBLIC, MIME_TYPE, SCOPE) VALUES (24, null, 'temp', TO_TIMESTAMP('2019-12-11 15:28:00.016000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'welcomefile', 'provider', 'Atitlanmain2.jpg', 'com.tigo.files.pathAtitlanmain2.jpg', 458618, 4, 0, 'image/jpeg', 'provider-welcome');
INSERT INTO SCORECARD.FILE_ITEM (ID, BUCKET_NAME, CREATED_BY, CREATED_DATE, DESCRIPTION, ENTITY_TYPE, FILE_NAME, FILE_PATH, FILE_SIZE, IDENTIFIER, IS_PUBLIC, MIME_TYPE, SCOPE) VALUES (47, null, 'temp', TO_TIMESTAMP('2019-12-19 01:09:41.898000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'quizfiles', 'quiz', 'pdf_generator.log', 'E://tmp//pdf_generator.log', 87835, 21, 0, 'application/octet-stream', 'provider-quiz');
INSERT INTO SCORECARD.FILE_ITEM (ID, BUCKET_NAME, CREATED_BY, CREATED_DATE, DESCRIPTION, ENTITY_TYPE, FILE_NAME, FILE_PATH, FILE_SIZE, IDENTIFIER, IS_PUBLIC, MIME_TYPE, SCOPE) VALUES (48, null, 'temp', TO_TIMESTAMP('2019-12-20 12:07:58.340000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'quizfiles', 'quiz', 'pdf_generator.log', 'E://tmp//pdf_generator.log', 87835, 22, 0, 'application/octet-stream', 'provider-quiz');
INSERT INTO SCORECARD.FILE_ITEM (ID, BUCKET_NAME, CREATED_BY, CREATED_DATE, DESCRIPTION, ENTITY_TYPE, FILE_NAME, FILE_PATH, FILE_SIZE, IDENTIFIER, IS_PUBLIC, MIME_TYPE, SCOPE) VALUES (49, null, 'temp', TO_TIMESTAMP('2019-12-20 12:08:12.075000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'quizfiles', 'quiz', 'quimera_service.log', 'E://tmp//quimera_service.log', 624193, 22, 0, 'application/octet-stream', 'provider-quiz');
INSERT INTO SCORECARD.FILE_ITEM (ID, BUCKET_NAME, CREATED_BY, CREATED_DATE, DESCRIPTION, ENTITY_TYPE, FILE_NAME, FILE_PATH, FILE_SIZE, IDENTIFIER, IS_PUBLIC, MIME_TYPE, SCOPE) VALUES (64, null, 'temp', TO_TIMESTAMP('2020-01-01 22:54:23.534000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'actionplanfiles', 'actionplandetails', 'fichosaInfoPrestamo.txt', 'E://tmp//fichosaInfoPrestamo.txt', 32, 2, 0, 'text/plain', 'provider-action-plan');
INSERT INTO SCORECARD.FILE_ITEM (ID, BUCKET_NAME, CREATED_BY, CREATED_DATE, DESCRIPTION, ENTITY_TYPE, FILE_NAME, FILE_PATH, FILE_SIZE, IDENTIFIER, IS_PUBLIC, MIME_TYPE, SCOPE) VALUES (65, null, 'temp', TO_TIMESTAMP('2020-01-04 22:07:19.457000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'quizfiles', 'quiz', 'RamSpec.PNG', 'E://tmp//RamSpec.PNG', 18455, 61, 0, 'image/png', 'provider-quiz');
INSERT INTO SCORECARD.FILE_ITEM (ID, BUCKET_NAME, CREATED_BY, CREATED_DATE, DESCRIPTION, ENTITY_TYPE, FILE_NAME, FILE_PATH, FILE_SIZE, IDENTIFIER, IS_PUBLIC, MIME_TYPE, SCOPE) VALUES (66, null, 'temp', TO_TIMESTAMP('2020-01-08 13:13:58.252000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'quizfiles', 'quiz', 'RamSpec11.PNG', 'E://tmp//RamSpec11.PNG', 18455, 4, 0, 'image/png', 'provider-quiz');
INSERT INTO SCORECARD.FILE_ITEM (ID, BUCKET_NAME, CREATED_BY, CREATED_DATE, DESCRIPTION, ENTITY_TYPE, FILE_NAME, FILE_PATH, FILE_SIZE, IDENTIFIER, IS_PUBLIC, MIME_TYPE, SCOPE) VALUES (67, null, 'temp', TO_TIMESTAMP('2020-01-08 20:15:01.611000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'quizfiles', 'quiz', 'RamSpec11.PNG', 'E://tmp//RamSpec11.PNG', 18455, 63, 0, 'image/png', 'provider-quiz');
INSERT INTO SCORECARD.FILE_ITEM (ID, BUCKET_NAME, CREATED_BY, CREATED_DATE, DESCRIPTION, ENTITY_TYPE, FILE_NAME, FILE_PATH, FILE_SIZE, IDENTIFIER, IS_PUBLIC, MIME_TYPE, SCOPE) VALUES (68, null, 'temp', TO_TIMESTAMP('2020-01-08 21:10:52.640000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'quizfiles', 'quiz', 'RamSpec11.PNG', 'E://tmp//RamSpec11.PNG', 18455, 63, 0, 'image/png', 'provider-quiz');
INSERT INTO SCORECARD.FILE_ITEM (ID, BUCKET_NAME, CREATED_BY, CREATED_DATE, DESCRIPTION, ENTITY_TYPE, FILE_NAME, FILE_PATH, FILE_SIZE, IDENTIFIER, IS_PUBLIC, MIME_TYPE, SCOPE) VALUES (86, null, 'temp', TO_TIMESTAMP('2020-01-16 00:00:28.782000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'welcomefile', 'provider', 'RamSpec (3).png', 'E://tmp//RamSpec (3).png', 18455, 44, null, 'image/png', 'provider-welcome');
INSERT INTO SCORECARD.FILE_ITEM (ID, BUCKET_NAME, CREATED_BY, CREATED_DATE, DESCRIPTION, ENTITY_TYPE, FILE_NAME, FILE_PATH, FILE_SIZE, IDENTIFIER, IS_PUBLIC, MIME_TYPE, SCOPE) VALUES (87, null, 'temp', TO_TIMESTAMP('2020-01-16 00:12:41.582000', 'YYYY-MM-DD HH24:MI:SS.FF6'), 'welcomefile', 'provider', 'RamSpec (2).png', 'E://tmp//RamSpec (2).png', 18455, 44, null, 'image/png', 'provider-welcome');
INSERT INTO SCORECARD.KPI (ID, NOMBRE, CREATED_DATE, UPDATED_DATE) VALUES (64, 'Nuevo Tipo de Evaluación', null, null);
INSERT INTO SCORECARD.KPI (ID, NOMBRE, CREATED_DATE, UPDATED_DATE) VALUES (4, 'EVALUACION 2019', TO_DATE('2019-11-13 19:48:55', 'YYYY-MM-DD HH24:MI:SS'), TO_TIMESTAMP('2019-11-13 19:48:55.592524', 'YYYY-MM-DD HH24:MI:SS.FF6'));
INSERT INTO SCORECARD.KPI (ID, NOMBRE, CREATED_DATE, UPDATED_DATE) VALUES (24, 'Nuevo test', TO_DATE('2019-11-13 19:48:55', 'YYYY-MM-DD HH24:MI:SS'), null);
INSERT INTO SCORECARD.LOG (LINE) VALUES ('_____');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('25');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('_____');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('21-12-2019 11:12');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('*****');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('*****----------');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('*****');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('*****----------');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('*****');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('*****----------');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('*****');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('*****----------');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('*****');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('*****----------');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('*****');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('*****----------');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('*****');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('*****----------');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('*****');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('*****----------');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('*****');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('*****----------');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('_____');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('25');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('_____');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('21-12-2019 12:12');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('_____');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('25');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('_____');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('21-12-2019 12:12');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('_____');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('25');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('_____');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('21-12-2019 03:12');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('_____');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('25');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('_____');
INSERT INTO SCORECARD.LOG (LINE) VALUES ('21-12-2019 03:12');
INSERT INTO SCORECARD.NOTIFICATION_TEMPLATE (ID, CREATED_BY, CREATED_ON, UPDATED_BY, UPDATED_ON, VERSION, BODY, NAME, SCOPE, STATUS, SUBJECT, TYPE) VALUES (1, 'admin', null, 'admin', null, 0, '<h3>Bienvenido a tigo!</h3><p style="font-size: 12.8px;"><strong>Hola ${(user.firstName)!} ${(user.lastName)!}</strong></p><p style="font-size: 12.8px;">Te damos la mas cordial bienvenido, tu usuario fue creado exitosamente.</p><p style="font-size: 12.8px;">Datos de ingreso:</p><ul style="font-size: 12.8px;"><li>User: ${(user.userName)!}</li><li>Email: ${(user.email)!}</li><li>Password: ${(user.password)!}</li></ul>', 'ususario.nuevo', 0, 1, 'Credenciales Acceso TIGO', 'javamail');
INSERT INTO SCORECARD.NOTIFICATION_TEMPLATE (ID, CREATED_BY, CREATED_ON, UPDATED_BY, UPDATED_ON, VERSION, BODY, NAME, SCOPE, STATUS, SUBJECT, TYPE) VALUES (2, 'admin', null, 'admin', null, 0, '<h3>Bienvenido a tigo!</h3><p style="font-size: 12.8px;"><strong>Hola ${(provider.name)!} </strong></p><p style="font-size: 12.8px;">Te damos la mas cordial bienvenido a la familia de proveedores tigo.</p><p style="font-size: 12.8px;"><strong>Contacto ${(provider.contacto)!} </strong></p><p></p><p style="font-size: 12.8px;"> Se Adjunta bienvenida:</p>', 'provider.new', 0, 1, 'Bienvenido a proveedores TIGO', 'javamail');
INSERT INTO SCORECARD.PLAN_ACCION (ID, OBJETIVO, ESTADO, MES, CREATED_BY, CREATED_DATE, UPDATED_BY, UPDATED_DATE, FECHA_COMPROMISO, AVANCE_PROVEEDOR, AVANCE_CM, NOMBRE, PROVEEDOR_ID, TIENE_EVENTO_NUEVO, MONTH, YEAR) VALUES (2, 'Mejor la calidad de atencion del proveedor', 'EN PROGRESO', null, null, null, null, null, TO_DATE('2020-01-18 18:00:00', 'YYYY-MM-DD HH24:MI:SS'), null, 34.00, 'Plan Accion Mes Enero', 4, null, '1', '2019');
INSERT INTO SCORECARD.PLAN_ACCION_DET (ID, COMENTARIO, CREATED_DATE, CREATED_BY, UPDATED_BY, ESTADO, PLAN_ACCION_ID, DESCRIPCION, FECHA_COMPROMISO, AVANCE, NOMBRE) VALUES (2, 'cometario actualizado por proveedor. 2. se hicieron nuevos ajustes para atencion 3. xyz', null, null, null, 'EN PROGRESO', 2, 'asdfasdf asfasdf', TO_DATE('2020-01-05 18:00:00', 'YYYY-MM-DD HH24:MI:SS'), 25.00, 'PUNTO DE ACCION DE PRUEBA');
INSERT INTO SCORECARD.PROVEEDORES (ID, CONTACTO, EMAIL, ESTADO, EVALUACION_ACTUAL, EVALUACION_GLOBAL, FECHA_CREACION, FECHA_ACTUALIZACION, CREADO_POR, TENDENCIA, NOMBRE, KPI_ID) VALUES (24, 'slll', 'slakjf@lkajl.com', 'A', null, null, null, null, null, null, 'Aris', 4);
INSERT INTO SCORECARD.PROVEEDORES (ID, CONTACTO, EMAIL, ESTADO, EVALUACION_ACTUAL, EVALUACION_GLOBAL, FECHA_CREACION, FECHA_ACTUALIZACION, CREADO_POR, TENDENCIA, NOMBRE, KPI_ID) VALUES (25, 'slll', 'slakjf@lkajl.com', 'A', null, null, null, null, null, null, 'Huawei', 4);
INSERT INTO SCORECARD.PROVEEDORES (ID, CONTACTO, EMAIL, ESTADO, EVALUACION_ACTUAL, EVALUACION_GLOBAL, FECHA_CREACION, FECHA_ACTUALIZACION, CREADO_POR, TENDENCIA, NOMBRE, KPI_ID) VALUES (44, 'Hector Perez', 'baguilar@innovare.es', 'A', null, null, null, null, null, null, 'Proveedor de prueba', 4);
INSERT INTO SCORECARD.PROVEEDORES (ID, CONTACTO, EMAIL, ESTADO, EVALUACION_ACTUAL, EVALUACION_GLOBAL, FECHA_CREACION, FECHA_ACTUALIZACION, CREADO_POR, TENDENCIA, NOMBRE, KPI_ID) VALUES (4, 'Ericsson', 'cristian.lucero@gmail.com', '1', null, 0.00, TO_DATE('2019-11-13 19:15:54', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-11-13 19:15:54', 'YYYY-MM-DD HH24:MI:SS'), 'admin', null, 'Ericson', 4);
INSERT INTO SCORECARD.PROVEEDOR_AGENDA (ID, TITULO, OBJETIVO, ES_RELEVANTE, ATENDERA_PROVEEDOR, FECHA_REUNION_INICIO, FECHA_REUNION_FIN, CREATED_BY, CREATED_DATE, UPDATED_BY, PROVEEDOR_ID, YEAR, ESTADO, MINUTA) VALUES (1, 'Reunion RPM mejoras', 'asdfasd', null, null, null, null, null, null, null, 4, 2020, 'PENDIENTE', 'aadfasdf');
INSERT INTO SCORECARD.PROVEEDOR_AGENDA (ID, TITULO, OBJETIVO, ES_RELEVANTE, ATENDERA_PROVEEDOR, FECHA_REUNION_INICIO, FECHA_REUNION_FIN, CREATED_BY, CREATED_DATE, UPDATED_BY, PROVEEDOR_ID, YEAR, ESTADO, MINUTA) VALUES (2, 'Reunion RPM mejoras', 'asdfasd', 1, null, TO_DATE('2020-01-09 18:00:00', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, null, 4, 2019, 'PENDIENTE', 'update');
INSERT INTO SCORECARD.PROVEEDOR_AGENDA (ID, TITULO, OBJETIVO, ES_RELEVANTE, ATENDERA_PROVEEDOR, FECHA_REUNION_INICIO, FECHA_REUNION_FIN, CREATED_BY, CREATED_DATE, UPDATED_BY, PROVEEDOR_ID, YEAR, ESTADO, MINUTA) VALUES (3, 'test', 'sssss', null, null, TO_DATE('2020-01-10 18:00:00', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, null, 4, 2020, 'PENDIENTE', null);
INSERT INTO SCORECARD.PROVEEDOR_AGENDA (ID, TITULO, OBJETIVO, ES_RELEVANTE, ATENDERA_PROVEEDOR, FECHA_REUNION_INICIO, FECHA_REUNION_FIN, CREATED_BY, CREATED_DATE, UPDATED_BY, PROVEEDOR_ID, YEAR, ESTADO, MINUTA) VALUES (4, 'asdf', 'asd', null, null, TO_DATE('2020-01-09 18:00:00', 'YYYY-MM-DD HH24:MI:SS'), null, null, null, null, 24, 2020, 'PENDIENTE', null);
INSERT INTO SCORECARD.SCORECARD_PROVIDER (ID, NAME, LAST_SCORE, BEFORE_SCORE, TOTAL_AVG, TARGET, YEAR, CREATED_DATE, UPDATED_DATE, PROVEEDORES_ID, MONTH, STATUS) VALUES (8, 'Ericson - ARRIS-cm', 3.56, null, 3.56, 5, '2019', TO_DATE('2019-12-21 10:58:00', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-12-21 20:06:48', 'YYYY-MM-DD HH24:MI:SS'), 4, '01', 'NO INICIADO');
INSERT INTO SCORECARD.SCORECARD_PROVIDER (ID, NAME, LAST_SCORE, BEFORE_SCORE, TOTAL_AVG, TARGET, YEAR, CREATED_DATE, UPDATED_DATE, PROVEEDORES_ID, MONTH, STATUS) VALUES (7, 'Ericson - TECNI', 2.56, null, 2.56, 5, '2019', TO_DATE('2019-12-21 07:44:46', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-12-21 08:35:50', 'YYYY-MM-DD HH24:MI:SS'), 4, '04', 'NO INICIADO');
INSERT INTO SCORECARD.SCORECARD_PROVIDER (ID, NAME, LAST_SCORE, BEFORE_SCORE, TOTAL_AVG, TARGET, YEAR, CREATED_DATE, UPDATED_DATE, PROVEEDORES_ID, MONTH, STATUS) VALUES (44, 'Ericson', 2.67, 2.67, 2.67, 5, '2019', TO_DATE('2019-12-31 15:14:58', 'YYYY-MM-DD HH24:MI:SS'), null, 4, '03', 'NO INICIADO');
INSERT INTO SCORECARD.SCORECARD_PROVIDER (ID, NAME, LAST_SCORE, BEFORE_SCORE, TOTAL_AVG, TARGET, YEAR, CREATED_DATE, UPDATED_DATE, PROVEEDORES_ID, MONTH, STATUS) VALUES (47, 'Ericson', null, null, null, 5, '2020', TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, 4, '01', 'NO INICIADO');
INSERT INTO SCORECARD.SCORECARD_PROVIDER (ID, NAME, LAST_SCORE, BEFORE_SCORE, TOTAL_AVG, TARGET, YEAR, CREATED_DATE, UPDATED_DATE, PROVEEDORES_ID, MONTH, STATUS) VALUES (9, 'Ericson', 4.56, null, 4.56, 5, '2018', TO_DATE('2019-12-21 04:28:35', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-12-21 07:44:09', 'YYYY-MM-DD HH24:MI:SS'), 4, '03', 'EN DIRECCION');
INSERT INTO SCORECARD.SCORECARD_PROVIDER (ID, NAME, LAST_SCORE, BEFORE_SCORE, TOTAL_AVG, TARGET, YEAR, CREATED_DATE, UPDATED_DATE, PROVEEDORES_ID, MONTH, STATUS) VALUES (24, 'Ericson - HUAWI', 2.56, null, 2.56, 5, '2019', TO_DATE('2019-12-21 07:44:46', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-12-21 08:35:50', 'YYYY-MM-DD HH24:MI:SS'), 4, '05', 'EN DIRECCION');
INSERT INTO SCORECARD.SCORECARD_PROVIDER (ID, NAME, LAST_SCORE, BEFORE_SCORE, TOTAL_AVG, TARGET, YEAR, CREATED_DATE, UPDATED_DATE, PROVEEDORES_ID, MONTH, STATUS) VALUES (25, 'Ericson - ARRIS', 2.56, null, 2.56, 5, '2019', TO_DATE('2019-12-21 10:58:00', 'YYYY-MM-DD HH24:MI:SS'), TO_DATE('2019-12-21 20:06:48', 'YYYY-MM-DD HH24:MI:SS'), 4, '02', 'EN GERENCIA');
INSERT INTO SCORECARD.SCORECARD_PROVIDER_COMMENTS (ID, COMMENTS, CREATED_DATE, CREATED_USER, SCORECARD_PROVIDER_ID) VALUES (1, 'comentarios', TO_DATE('2019-12-31 15:23:05', 'YYYY-MM-DD HH24:MI:SS'), 'clucero', 9);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_COMMENTS (ID, COMMENTS, CREATED_DATE, CREATED_USER, SCORECARD_PROVIDER_ID) VALUES (2, 'comentarios 2', TO_DATE('2019-12-31 15:23:05', 'YYYY-MM-DD HH24:MI:SS'), 'clucero', 9);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_COMMENTS (ID, COMMENTS, CREATED_DATE, CREATED_USER, SCORECARD_PROVIDER_ID) VALUES (3, 'comentarios 23', TO_DATE('2019-12-31 15:23:05', 'YYYY-MM-DD HH24:MI:SS'), 'clucero', 25);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_COMMENTS (ID, COMMENTS, CREATED_DATE, CREATED_USER, SCORECARD_PROVIDER_ID) VALUES (4, 'comentarios xy', TO_DATE('2019-12-31 15:23:05', 'YYYY-MM-DD HH24:MI:SS'), 'clucero', 25);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_COMMENTS (ID, COMMENTS, CREATED_DATE, CREATED_USER, SCORECARD_PROVIDER_ID) VALUES (5, null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, 47);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_COMMENTS (ID, COMMENTS, CREATED_DATE, CREATED_USER, SCORECARD_PROVIDER_ID) VALUES (6, null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, 47);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_COMMENTS (ID, COMMENTS, CREATED_DATE, CREATED_USER, SCORECARD_PROVIDER_ID) VALUES (7, null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, 47);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_COMMENTS (ID, COMMENTS, CREATED_DATE, CREATED_USER, SCORECARD_PROVIDER_ID) VALUES (8, null, TO_DATE('2019-12-18 21:43:39', 'YYYY-MM-DD HH24:MI:SS'), null, 47);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_COMMENTS (ID, COMMENTS, CREATED_DATE, CREATED_USER, SCORECARD_PROVIDER_ID) VALUES (9, 'asdfasdf', TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), 'adminchange', 47);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_COMMENTS (ID, COMMENTS, CREATED_DATE, CREATED_USER, SCORECARD_PROVIDER_ID) VALUES (10, 'yeerty', TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), 'adminchange', 47);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_COMMENTS (ID, COMMENTS, CREATED_DATE, CREATED_USER, SCORECARD_PROVIDER_ID) VALUES (11, '454rghfgh', TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), 'adminchange', 47);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_COMMENTS (ID, COMMENTS, CREATED_DATE, CREATED_USER, SCORECARD_PROVIDER_ID) VALUES (12, '353tgggrghrth', TO_DATE('2019-12-18 21:47:29', 'YYYY-MM-DD HH24:MI:SS'), 'adminchange', 47);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_COMMENTS (ID, COMMENTS, CREATED_DATE, CREATED_USER, SCORECARD_PROVIDER_ID) VALUES (13, 'nuevos comentarios', TO_DATE('2019-12-20 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), 'adminchange', 47);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_COMMENTS (ID, COMMENTS, CREATED_DATE, CREATED_USER, SCORECARD_PROVIDER_ID) VALUES (14, 'otro', TO_DATE('2019-12-20 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), 'adminchange', 47);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_COMMENTS (ID, COMMENTS, CREATED_DATE, CREATED_USER, SCORECARD_PROVIDER_ID) VALUES (15, 'xyz', TO_DATE('2019-12-20 12:07:41', 'YYYY-MM-DD HH24:MI:SS'), 'adminchange', 47);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (82, '2', 1.67, 1.67, TO_DATE('2019-12-21 20:06:48', 'YYYY-MM-DD HH24:MI:SS'), null, null, 25, 2.00, 2.00, 'Cumplimiento de Agenda', 'Soporte de averias', 'NO INICIADO', 5, 4);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (83, '2', 1.67, 1.67, TO_DATE('2019-12-21 20:06:48', 'YYYY-MM-DD HH24:MI:SS'), null, null, 25, 1.00, 1.00, 'Cumplimiento de SLAs', 'Soporte de averias', 'NO INICIADO', 5, 5);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (84, '2', 1.67, 1.67, TO_DATE('2019-12-21 20:06:48', 'YYYY-MM-DD HH24:MI:SS'), null, null, 25, 2.00, 2.00, 'Calidad de servicio de instalación', 'Soporte de averias', 'NO INICIADO', 5, 6);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (85, '2', 2.33, 2.33, TO_DATE('2019-12-21 20:06:48', 'YYYY-MM-DD HH24:MI:SS'), null, null, 25, 2.00, 2.00, 'Cumplimiento de agenda', 'Planificacion e instalaciones', 'NO INICIADO', 6, 7);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (86, '2', 2.33, 2.33, TO_DATE('2019-12-21 20:06:48', 'YYYY-MM-DD HH24:MI:SS'), null, null, 25, 3.00, 3.00, 'Calidad de instalación', 'Planificacion e instalaciones', 'NO INICIADO', 6, 8);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (87, '2', 2.33, 2.33, TO_DATE('2019-12-21 20:06:48', 'YYYY-MM-DD HH24:MI:SS'), null, null, 25, 2.00, 2.00, 'Desempeño en proyectos especiales', 'Planificacion e instalaciones', 'NO INICIADO', 6, 9);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (88, '2', 3.67, 3.67, TO_DATE('2019-12-21 20:06:48', 'YYYY-MM-DD HH24:MI:SS'), null, null, 25, 3.00, 3.00, 'Cumplimiento de procesos', 'Manejo de Cuentas', 'NO INICIADO', 7, 10);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (89, '2', 3.67, 3.67, TO_DATE('2019-12-21 20:06:48', 'YYYY-MM-DD HH24:MI:SS'), null, null, 25, 4.00, 4.00, 'Disposición en problemas', 'Manejo de Cuentas', 'NO INICIADO', 7, 11);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (90, '2', 3.67, 3.67, TO_DATE('2019-12-21 20:06:48', 'YYYY-MM-DD HH24:MI:SS'), null, null, 25, 4.00, 4.00, 'Manejo de inventarios', 'Manejo de Cuentas', 'NO INICIADO', 7, 12);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (1, '2', 1.67, 1.67, TO_DATE('2019-12-21 20:06:48', 'YYYY-MM-DD HH24:MI:SS'), null, null, 9, 2.00, 2.00, 'Cumplimiento de Agenda', 'Soporte de averias', 'NO INICIADO', 5, 4);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (101, '3', 1.67, 1.67, TO_DATE('2019-12-31 15:14:58', 'YYYY-MM-DD HH24:MI:SS'), null, null, 44, 1.00, 1.00, 'Cumplimiento de Agenda', 'Soporte de averias', 'NO INICIADO', 5, 4);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (102, '3', 1.67, 1.67, TO_DATE('2019-12-31 15:14:58', 'YYYY-MM-DD HH24:MI:SS'), null, null, 44, 2.00, 2.00, 'Cumplimiento de SLAs', 'Soporte de averias', 'NO INICIADO', 5, 5);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (103, '3', 1.67, 1.67, TO_DATE('2019-12-31 15:14:58', 'YYYY-MM-DD HH24:MI:SS'), null, null, 44, 2.00, 2.00, 'Calidad de servicio de instalación', 'Soporte de averias', 'NO INICIADO', 5, 6);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (104, '3', 3.33, 3.33, TO_DATE('2019-12-31 15:14:58', 'YYYY-MM-DD HH24:MI:SS'), null, null, 44, 4.00, 4.00, 'Cumplimiento de agenda', 'Planificacion e instalaciones', 'NO INICIADO', 6, 7);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (105, '3', 3.33, 3.33, TO_DATE('2019-12-31 15:14:58', 'YYYY-MM-DD HH24:MI:SS'), null, null, 44, 2.00, 2.00, 'Calidad de instalación', 'Planificacion e instalaciones', 'NO INICIADO', 6, 8);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (106, '3', 3.33, 3.33, TO_DATE('2019-12-31 15:14:58', 'YYYY-MM-DD HH24:MI:SS'), null, null, 44, 4.00, 4.00, 'Desempeño en proyectos especiales', 'Planificacion e instalaciones', 'NO INICIADO', 6, 9);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (107, '3', 3.00, 3.00, TO_DATE('2019-12-31 15:14:58', 'YYYY-MM-DD HH24:MI:SS'), null, null, 44, 4.00, 4.00, 'Cumplimiento de procesos', 'Manejo de Cuentas', 'NO INICIADO', 7, 10);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (108, '3', 3.00, 3.00, TO_DATE('2019-12-31 15:14:58', 'YYYY-MM-DD HH24:MI:SS'), null, null, 44, 4.00, 4.00, 'Disposición en problemas', 'Manejo de Cuentas', 'NO INICIADO', 7, 11);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (109, '3', 3.00, 3.00, TO_DATE('2019-12-31 15:14:58', 'YYYY-MM-DD HH24:MI:SS'), null, null, 44, 1.00, 1.00, 'Manejo de inventarios', 'Manejo de Cuentas', 'NO INICIADO', 7, 12);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (318, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de Agenda', 'Soporte de averias', 'NO INICIADO', 5, 4);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (319, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de SLAs', 'Soporte de averias', 'NO INICIADO', 5, 5);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (320, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de servicio de instalación', 'Soporte de averias', 'NO INICIADO', 5, 6);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (321, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de agenda', 'Planificacion e instalaciones', 'NO INICIADO', 6, 7);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (322, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de instalación', 'Planificacion e instalaciones', 'NO INICIADO', 6, 8);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (323, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Desempeño en proyectos especiales', 'Planificacion e instalaciones', 'NO INICIADO', 6, 9);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (324, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de procesos', 'Manejo de Cuentas', 'NO INICIADO', 7, 10);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (325, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Disposición en problemas', 'Manejo de Cuentas', 'NO INICIADO', 7, 11);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (326, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Manejo de inventarios', 'Manejo de Cuentas', 'NO INICIADO', 7, 12);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (327, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de Agenda', 'Soporte de averias', 'NO INICIADO', 5, 4);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (328, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de SLAs', 'Soporte de averias', 'NO INICIADO', 5, 5);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (329, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de servicio de instalación', 'Soporte de averias', 'NO INICIADO', 5, 6);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (330, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de agenda', 'Planificacion e instalaciones', 'NO INICIADO', 6, 7);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (331, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de instalación', 'Planificacion e instalaciones', 'NO INICIADO', 6, 8);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (332, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Desempeño en proyectos especiales', 'Planificacion e instalaciones', 'NO INICIADO', 6, 9);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (333, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de procesos', 'Manejo de Cuentas', 'NO INICIADO', 7, 10);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (334, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Disposición en problemas', 'Manejo de Cuentas', 'NO INICIADO', 7, 11);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (335, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Manejo de inventarios', 'Manejo de Cuentas', 'NO INICIADO', 7, 12);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (336, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de Agenda', 'Soporte de averias', 'NO INICIADO', 5, 4);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (337, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de SLAs', 'Soporte de averias', 'NO INICIADO', 5, 5);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (338, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de servicio de instalación', 'Soporte de averias', 'NO INICIADO', 5, 6);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (339, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de agenda', 'Planificacion e instalaciones', 'NO INICIADO', 6, 7);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (340, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de instalación', 'Planificacion e instalaciones', 'NO INICIADO', 6, 8);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (341, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Desempeño en proyectos especiales', 'Planificacion e instalaciones', 'NO INICIADO', 6, 9);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (342, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de procesos', 'Manejo de Cuentas', 'NO INICIADO', 7, 10);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (343, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Disposición en problemas', 'Manejo de Cuentas', 'NO INICIADO', 7, 11);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (344, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Manejo de inventarios', 'Manejo de Cuentas', 'NO INICIADO', 7, 12);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (345, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de Agenda', 'Soporte de averias', 'NO INICIADO', 5, 4);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (346, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de SLAs', 'Soporte de averias', 'NO INICIADO', 5, 5);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (347, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de servicio de instalación', 'Soporte de averias', 'NO INICIADO', 5, 6);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (348, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de agenda', 'Planificacion e instalaciones', 'NO INICIADO', 6, 7);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (349, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de instalación', 'Planificacion e instalaciones', 'NO INICIADO', 6, 8);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (350, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Desempeño en proyectos especiales', 'Planificacion e instalaciones', 'NO INICIADO', 6, 9);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (351, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de procesos', 'Manejo de Cuentas', 'NO INICIADO', 7, 10);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (352, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Disposición en problemas', 'Manejo de Cuentas', 'NO INICIADO', 7, 11);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (353, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Manejo de inventarios', 'Manejo de Cuentas', 'NO INICIADO', 7, 12);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (354, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de Agenda', 'Soporte de averias', 'NO INICIADO', 5, 4);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (355, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de SLAs', 'Soporte de averias', 'NO INICIADO', 5, 5);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (356, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de servicio de instalación', 'Soporte de averias', 'NO INICIADO', 5, 6);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (357, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de agenda', 'Planificacion e instalaciones', 'NO INICIADO', 6, 7);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (358, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de instalación', 'Planificacion e instalaciones', 'NO INICIADO', 6, 8);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (359, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Desempeño en proyectos especiales', 'Planificacion e instalaciones', 'NO INICIADO', 6, 9);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (360, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de procesos', 'Manejo de Cuentas', 'NO INICIADO', 7, 10);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (361, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Disposición en problemas', 'Manejo de Cuentas', 'NO INICIADO', 7, 11);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (362, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Manejo de inventarios', 'Manejo de Cuentas', 'NO INICIADO', 7, 12);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (363, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de Agenda', 'Soporte de averias', 'NO INICIADO', 5, 4);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (364, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de SLAs', 'Soporte de averias', 'NO INICIADO', 5, 5);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (365, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de servicio de instalación', 'Soporte de averias', 'NO INICIADO', 5, 6);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (366, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de agenda', 'Planificacion e instalaciones', 'NO INICIADO', 6, 7);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (367, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de instalación', 'Planificacion e instalaciones', 'NO INICIADO', 6, 8);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (368, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Desempeño en proyectos especiales', 'Planificacion e instalaciones', 'NO INICIADO', 6, 9);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (369, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de procesos', 'Manejo de Cuentas', 'NO INICIADO', 7, 10);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (370, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Disposición en problemas', 'Manejo de Cuentas', 'NO INICIADO', 7, 11);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (371, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Manejo de inventarios', 'Manejo de Cuentas', 'NO INICIADO', 7, 12);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (372, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de Agenda', 'Soporte de averias', 'NO INICIADO', 5, 4);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (373, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de SLAs', 'Soporte de averias', 'NO INICIADO', 5, 5);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (374, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de servicio de instalación', 'Soporte de averias', 'NO INICIADO', 5, 6);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (375, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de agenda', 'Planificacion e instalaciones', 'NO INICIADO', 6, 7);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (376, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de instalación', 'Planificacion e instalaciones', 'NO INICIADO', 6, 8);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (377, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Desempeño en proyectos especiales', 'Planificacion e instalaciones', 'NO INICIADO', 6, 9);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (378, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de procesos', 'Manejo de Cuentas', 'NO INICIADO', 7, 10);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (379, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Disposición en problemas', 'Manejo de Cuentas', 'NO INICIADO', 7, 11);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (380, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Manejo de inventarios', 'Manejo de Cuentas', 'NO INICIADO', 7, 12);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (381, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de Agenda', 'Soporte de averias', 'NO INICIADO', 5, 4);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (382, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de SLAs', 'Soporte de averias', 'NO INICIADO', 5, 5);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (383, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de servicio de instalación', 'Soporte de averias', 'NO INICIADO', 5, 6);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (384, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de agenda', 'Planificacion e instalaciones', 'NO INICIADO', 6, 7);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (385, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de instalación', 'Planificacion e instalaciones', 'NO INICIADO', 6, 8);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (386, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Desempeño en proyectos especiales', 'Planificacion e instalaciones', 'NO INICIADO', 6, 9);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (387, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de procesos', 'Manejo de Cuentas', 'NO INICIADO', 7, 10);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (388, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Disposición en problemas', 'Manejo de Cuentas', 'NO INICIADO', 7, 11);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (389, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Manejo de inventarios', 'Manejo de Cuentas', 'NO INICIADO', 7, 12);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (390, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de Agenda', 'Soporte de averias', 'NO INICIADO', 5, 4);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (391, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de SLAs', 'Soporte de averias', 'NO INICIADO', 5, 5);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (392, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de servicio de instalación', 'Soporte de averias', 'NO INICIADO', 5, 6);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (393, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de agenda', 'Planificacion e instalaciones', 'NO INICIADO', 6, 7);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (394, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de instalación', 'Planificacion e instalaciones', 'NO INICIADO', 6, 8);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (395, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Desempeño en proyectos especiales', 'Planificacion e instalaciones', 'NO INICIADO', 6, 9);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (396, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de procesos', 'Manejo de Cuentas', 'NO INICIADO', 7, 10);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (397, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Disposición en problemas', 'Manejo de Cuentas', 'NO INICIADO', 7, 11);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (398, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Manejo de inventarios', 'Manejo de Cuentas', 'NO INICIADO', 7, 12);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (399, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de Agenda', 'Soporte de averias', 'NO INICIADO', 5, 4);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (400, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de SLAs', 'Soporte de averias', 'NO INICIADO', 5, 5);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (401, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de servicio de instalación', 'Soporte de averias', 'NO INICIADO', 5, 6);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (402, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de agenda', 'Planificacion e instalaciones', 'NO INICIADO', 6, 7);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (403, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de instalación', 'Planificacion e instalaciones', 'NO INICIADO', 6, 8);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (404, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Desempeño en proyectos especiales', 'Planificacion e instalaciones', 'NO INICIADO', 6, 9);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (405, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de procesos', 'Manejo de Cuentas', 'NO INICIADO', 7, 10);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (406, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Disposición en problemas', 'Manejo de Cuentas', 'NO INICIADO', 7, 11);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (407, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Manejo de inventarios', 'Manejo de Cuentas', 'NO INICIADO', 7, 12);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (408, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de Agenda', 'Soporte de averias', 'NO INICIADO', 5, 4);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (409, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de SLAs', 'Soporte de averias', 'NO INICIADO', 5, 5);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (410, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de servicio de instalación', 'Soporte de averias', 'NO INICIADO', 5, 6);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (411, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de agenda', 'Planificacion e instalaciones', 'NO INICIADO', 6, 7);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (412, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de instalación', 'Planificacion e instalaciones', 'NO INICIADO', 6, 8);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (413, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Desempeño en proyectos especiales', 'Planificacion e instalaciones', 'NO INICIADO', 6, 9);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (414, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de procesos', 'Manejo de Cuentas', 'NO INICIADO', 7, 10);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (415, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Disposición en problemas', 'Manejo de Cuentas', 'NO INICIADO', 7, 11);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (416, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Manejo de inventarios', 'Manejo de Cuentas', 'NO INICIADO', 7, 12);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (417, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de Agenda', 'Soporte de averias', 'NO INICIADO', 5, 4);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (418, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de SLAs', 'Soporte de averias', 'NO INICIADO', 5, 5);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (419, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de servicio de instalación', 'Soporte de averias', 'NO INICIADO', 5, 6);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (420, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Cumplimiento de agenda', 'Planificacion e instalaciones', 'NO INICIADO', 6, 7);
INSERT INTO SCORECARD.SCORECARD_PROVIDER_MONTH (ID, MONTH, SCORE, BEFORE_SCORE, CREATED_DATE, UPDATED_DATE, CREATED_BY, SCORECARD_PROVIDER_ID, SCORE_CATEGORY, BEFORE_SCORE_CATEGORY, NOMBRE_CATEGORIA, NOMBRE_AREA, ESTADO, ID_AREA, ID_CATEGORIA) VALUES (421, '1', null, null, TO_DATE('2019-12-31 15:34:21', 'YYYY-MM-DD HH24:MI:SS'), null, null, 47, null, null, 'Calidad de instalación', 'Planificacion e instalaciones', 'NO INICIADO', 6, 8);
INSERT INTO SCORECARD.USERS (ID, USER_NAME, PASSWORD, USER_TYPE, EMAIL, STATUS, ENABLED, FIRST_NAME, LAST_NAME) VALUES (1, 'admin', '$2a$10$7fUbUVGFwcLHbB3gQvLHSuuPHG5ZRV/qwbOvB.xXwNoVMD2p6.oey', 'super', 'adming@agmin.com', '1', '1', 'tigo', 'admin');
INSERT INTO SCORECARD.USERS (ID, USER_NAME, PASSWORD, USER_TYPE, EMAIL, STATUS, ENABLED, FIRST_NAME, LAST_NAME) VALUES (44, 'contractmanager1', 't4svwidi53dw', 'Contract Manager', 'cristian.lucero@gmail.com', 'A', null, 'tigo', 'contractmanager');
INSERT INTO SCORECARD.USERS (ID, USER_NAME, PASSWORD, USER_TYPE, EMAIL, STATUS, ENABLED, FIRST_NAME, LAST_NAME) VALUES (45, 'contractmanager', '{bcrypt}$2a$10$dXJ3SW6G7P50lGmMkkmwe.20cQQubK3.HZWzG3YB1tlRy.fqvM/BG', 'Contract Manager', 'cristian.lucero@gmail.com', null, null, 'tigo', 'contractmanager');



