/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.hal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.core.EmbeddedWrapper;
import org.springframework.hateoas.core.EmbeddedWrappers;
import org.springframework.hateoas.hal.CurieProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class HalEmbeddedBuilder {
    private static final String DEFAULT_REL = "content";
    private static final String INVALID_EMBEDDED_WRAPPER = "Embedded wrapper %s returned null for both the static rel and the rel target type! Make sure one of the two returns a non-null value!";
    private final Map<String, Object> embeddeds = new HashMap<String, Object>();
    private final RelProvider provider;
    private final CurieProvider curieProvider;
    private final EmbeddedWrappers wrappers;

    public HalEmbeddedBuilder(RelProvider provider, CurieProvider curieProvider, boolean preferCollectionRels) {
        Assert.notNull((Object)provider, (String)"Relprovider must not be null!");
        this.provider = provider;
        this.curieProvider = curieProvider;
        this.wrappers = new EmbeddedWrappers(preferCollectionRels);
    }

    public void add(Object source) {
        String collectionRel;
        EmbeddedWrapper wrapper = this.wrappers.wrap(source);
        if (wrapper == null) {
            return;
        }
        String collectionOrItemRel = collectionRel = this.getDefaultedRelFor(wrapper, true);
        if (!this.embeddeds.containsKey(collectionRel)) {
            collectionOrItemRel = this.getDefaultedRelFor(wrapper, wrapper.isCollectionValue());
        }
        Object currentValue = this.embeddeds.get(collectionOrItemRel);
        Object value = wrapper.getValue();
        if (currentValue == null && !wrapper.isCollectionValue()) {
            this.embeddeds.put(collectionOrItemRel, value);
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(this.asCollection(currentValue));
        list.addAll(this.asCollection(wrapper.getValue()));
        this.embeddeds.remove(collectionOrItemRel);
        this.embeddeds.put(collectionRel, list);
    }

    private Collection<Object> asCollection(Object source) {
        return source instanceof Collection ? (Set<Object>)source : (source == null ? Collections.emptySet() : Collections.singleton(source));
    }

    private String getDefaultedRelFor(EmbeddedWrapper wrapper, boolean forCollection) {
        String rel;
        String valueRel = wrapper.getRel();
        if (StringUtils.hasText((String)valueRel)) {
            return valueRel;
        }
        if (this.provider == null) {
            return DEFAULT_REL;
        }
        Class<?> type = wrapper.getRelTargetType();
        if (type == null) {
            throw new IllegalStateException(String.format(INVALID_EMBEDDED_WRAPPER, wrapper));
        }
        String string = rel = forCollection ? this.provider.getCollectionResourceRelFor(type) : this.provider.getItemResourceRelFor(type);
        if (this.curieProvider != null) {
            rel = this.curieProvider.getNamespacedRelFor(rel);
        }
        return rel == null ? DEFAULT_REL : rel;
    }

    public Map<String, Object> asMap() {
        return Collections.unmodifiableMap(this.embeddeds);
    }
}

